package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.monitor.LogisticsMonitorReportDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.MonitorReportQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteMonitorReportService;
import com.qiho.manager.biz.runnable.MonitorReportExportRunnable;
import com.qiho.manager.biz.service.LogisticsMonitorReportService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.biz.vo.monitor.LogisticsMonitorReportVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * Created by qianjue on 2017/11/2.
 */
@Service
public class LogisticsMonitorReportServiceImpl implements LogisticsMonitorReportService,ApplicationContextAware {

	@Autowired
	private ApplicationContext applicationContext;

	@Resource
	private ExecutorService executorService;

	@Resource(name = "stringRedisTemplate")
	private StringRedisTemplate redisTemplate;

	@Resource
	private RemoteMonitorReportService remoteMonitorReportService;
	@Resource
	private LogisticsService logisticsService;

	@Override
	public List<LogisticsMonitorReportVO> queryList(MonitorReportQueryParam param) {
		List<LogisticsMonitorReportDto> dtoList =  remoteMonitorReportService.queryList(param);
		if(CollectionUtils.isEmpty(dtoList)){
			return Lists.newArrayList();
		}
		List<LogisticsMonitorReportVO> list = Lists.newArrayList();
		Map<String, String> logisticsMap = logisticsService.getBaiqiLogisticsCodeToName();
		dtoList.forEach(dto->{
			LogisticsMonitorReportVO vo = BeanUtils.copy(dto,LogisticsMonitorReportVO.class);
			vo.setLogisticsName(logisticsMap.get(dto.getLogisticsCode()));
			vo.setWarehouseName("富阳仓库");
			if(StringUtils.equals(dto.getMonitorStatus(), OrderStatusEnum.TO_SEND.getCode())){
				vo.setMonitorStatusName(OrderStatusEnum.TO_SEND.getDesc());
			}else{
				vo.setMonitorStatusName(LogisticsOrderStatusEnum.getByCode(dto.getMonitorStatus()).getDesc());
			}
			list.add(vo);
		});
		return list;
	}

	@Override
	public Map<String, Object> exportList(MonitorReportQueryParam param) {
		List<LogisticsMonitorReportDto> result = remoteMonitorReportService.queryList(param);
		int count = result.size();
		if(count <= 0 ){
			throw new QihoManagerException("没有需要导出的记录");
		}
		MonitorReportExportRunnable runnable = applicationContext.getBean(MonitorReportExportRunnable.class);
		runnable.setQueryParam(param);
		Map<String,Object> info = runnable.init();
		info.put("count",count);
		//执行直接测试用
		executorService.submit(runnable);
		return info;
	}


	@Override
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	@Override
	public JSONObject queryExpressBlackExportStatus(String taskId) {
		CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_MONITOR_REPORT;
		String cacheKey = constantseEnum.getCacheKey(taskId);
		BoundHashOperations<String,String,Object> operations = redisTemplate.boundHashOps(cacheKey);
		Map<String,Object> info = operations.entries();
		JSONObject json = new JSONObject();
		if(info.isEmpty()){
			json.put("success",true);
		}else{
			json.putAll(info);
		}
		json.put("success",json.getBoolean("success"));
		return json;
	}
}
