package com.qiho.manager.biz.service.impl;/**
 * Created by Administrator on 2017/11/15 0015.
 */

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.OpenInterfaceTypeEnum;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.service.MerchantService;
import com.qiho.manager.biz.vo.MerchantSimpleVO;
import com.qiho.manager.biz.vo.OpenInterfaceVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.merchant.MerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AppSecretUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2017-11-15 10:50
 **/
@Service
public class MerchantSerivceImpl implements MerchantService {

    /**
     * 之前appkey是用的商户Id
     * 新增了代理商后， appkey可能会重复， 加个a前缀区别下
     */
    public static final String APP_KEY_AGENT_PREFIX = "a";

    @Autowired
    private RemoteMerchantService remoteMerchantService;

    @Autowired
    private RemoteBaiqiAgentService remoteBaiqiAgentService;

    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Autowired
    private RemoteAdminService remoteAdminService;

    @Override
    public Boolean saveMerchant(MerchantDto dto) {
        if (dto.getId() == null) {
            dto.setGmtCreator(RequestTool.getAdminId());
            dto.setGmtCreate(new Date());
        }
        dto.setGmtModified(new Date());
        dto.setGmtModifier(RequestTool.getAdminId());
        dto.setOwnerAeId(RequestTool.getAdminId());
        try {
            return remoteMerchantService.saveMerchant(dto);
        } catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public MerchantVO findById(Long merchantId) {
        MerchantDto dto = remoteMerchantService.findById(merchantId);
        if (null == dto || dto.getId() == null) {
            throw new QihoManagerException("商家Id不存在");
        }
        MerchantVO merchantVO = BeanUtils.copy(dto, MerchantVO.class);
        if (StringUtils.isNotBlank(merchantVO.getDelivery())) {
            merchantVO.setDelivery(DeliveryEnum.getByCode(merchantVO.getDelivery()).getDesc());
        }
        return merchantVO;
    }

    @Override
    public List<MerchantVO> listByName(String name) {
        if (StringUtils.isBlank(name)) {
            return Collections.emptyList();
        }
        List<MerchantDto> merchantDtoList = remoteMerchantService.findListByName(name.trim());
        if (CollectionUtils.isEmpty(merchantDtoList)) {
            return Lists.newArrayList();
        }
        return BeanUtils.copyList(merchantDtoList, MerchantVO.class);
    }

    @Override
    public Pagenation<MerchantVO> pageQuery(MerchantQueryParams params) {

        boolean flag = hasSeeAllPermission("seeAllMerchant");

        if(!flag){
            params.setOwnerAeId(RequestTool.getAdminId());
        }

        Pagenation<MerchantVO> page = new Pagenation<>();
        PagenationDto<MerchantDto> result = remoteMerchantService.querypage(params);
        page.setTotal(result.getTotal());
        // 校验是否有返回数据
        if (result.getTotal().intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }

        List<MerchantDto> merchantDtos = result.getList();
        List<Long> aeIds = merchantDtos.stream().map(MerchantDto::getOwnerAeId).filter(Objects::nonNull).collect(Collectors.toList());
        List<AdminDto> adminDtos = remoteAdminService.batchFindAdminByIds(aeIds);
        Map<Long, String> aeIdNameMap = adminDtos.stream().collect(Collectors.toMap(AdminDto::getId, AdminDto::getName, (o, n) -> o));

        // 类型转换
        List<MerchantVO> merchantVOList = Lists.transform(merchantDtos, e -> {
            MerchantVO merchantVO = BeanUtils.copy(e, MerchantVO.class);
            if (StringUtils.isNotBlank(merchantVO.getDelivery())) {
                merchantVO.setDelivery(DeliveryEnum.getByCode(merchantVO.getDelivery()).getDesc());
            }
            Long ownerAeId = e.getOwnerAeId();
            Optional.ofNullable(ownerAeId).ifPresent(tempOwnerAeId -> merchantVO.setOwnerAe(aeIdNameMap.get(tempOwnerAeId)));

            return merchantVO;
        });

        page.setList(merchantVOList);
        return page;
    }

    /**
     * 当前登陆人是否拥有对应的权限
     *
     * @param permissionCode 权限码
     * @return
     */
    private boolean hasSeeAllPermission(String permissionCode) {
        return adminPowerCacheService.hasPower(RequestTool.getAdminId(), permissionCode);
    }

    @Override
    public String findByMerchantId(Long merchantId) {
        MerchantDto dto = remoteMerchantService.findById(merchantId);
        if (null == dto || dto.getId() == null) {
            throw new QihoManagerException("商家Id不存在");
        }
        MerchantVO merchantVO = BeanUtils.copy(dto, MerchantVO.class);
        if (StringUtils.isNotBlank(merchantVO.getDelivery())) {
            merchantVO.setDelivery(DeliveryEnum.getByCode(merchantVO.getDelivery()).getDesc());
        }
        return merchantVO.getDelivery();
    }

    @Override
    public List<SpecialSimpleVO> findSimpleAll() {
        List<SpecialSimpleVO> vos = new ArrayList<>();
        List<MerchantSpacialDto> list = remoteMerchantService.findAll();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        for (MerchantSpacialDto dto : list) {
            SpecialSimpleVO vo = new SpecialSimpleVO();
            vo.setId(dto.getId());
            vo.setContactName(dto.getContactName());
            vo.setName(dto.getMerchantName());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public Long findRelationId(Long merchantId, BaiqiMerchantLinkTypeEnum relationType) {
        return remoteMerchantService.findRelationIdByMerchantIdAndRelationType(merchantId, relationType);
    }

    @Override
    public Pagenation<OpenInterfaceVO> openInterfacePageQuery(OpenInterfaceQueryParams params) {

        PagenationDto<OpenInterfaceDto> result = remoteMerchantService.openInterfacePageQuery(params);

        Pagenation<OpenInterfaceVO> pagenation = new Pagenation<>();
        pagenation.setTotal(result.getTotal());
        pagenation.setList(dtoListToVoList(result.getList()));

        return pagenation;
    }

    private List<OpenInterfaceVO> dtoListToVoList(List<OpenInterfaceDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        return dtoList.stream().map(this::dtoToVo).collect(Collectors.toList());
    }

    private OpenInterfaceVO dtoToVo(OpenInterfaceDto dto) {
        if (dto == null) {
            return null;
        }
        OpenInterfaceVO openInterfaceVO = new OpenInterfaceVO();

        openInterfaceVO.setMerchantId(dto.getMerchantId());
        openInterfaceVO.setMerchantName(dto.getMerchantName());
        openInterfaceVO.setAppKey(dto.getAppkey());
        openInterfaceVO.setAppSecret(dto.getAppsecret());
        openInterfaceVO.setInterfaceType(dto.getInterfaceType());
        if (dto.getGmtCreate() != null || dto.getGmtModified() != null) {
            openInterfaceVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dto.getGmtCreate()));
            openInterfaceVO.setGmtModified(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dto.getGmtModified()));
        }
        return openInterfaceVO;
    }

    @Override
    public Boolean saveOpenInterface(Long merchantId) {

        MerchantDto dto = remoteMerchantService.findById(merchantId);
        if (null == dto || null == dto.getId()) {
            throw new QihoManagerException("商家Id不存在");
        }

        if (null != remoteMerchantService.findByMerchantId(merchantId)) {
            throw new QihoManagerException("该商家已存在");
        }

        String appKey = merchantId.toString();
        if (null != remoteMerchantService.findByAppKey(appKey)) {
            throw new QihoManagerException("APPkey已存在");
        }

        OpenInterfaceDto openInterfaceDto = new OpenInterfaceDto();
        openInterfaceDto.setMerchantId(merchantId);
        openInterfaceDto.setAppkey(appKey);
        openInterfaceDto.setAppsecret(AppSecretUtil.getAppSecret());
        openInterfaceDto.setGmtCreate(new Date());
        openInterfaceDto.setGmtModified(new Date());

        return (remoteMerchantService.saveOpenInterface(openInterfaceDto));
    }

    @Override
    public Boolean saveAgentOpenInterface(Long agentId){
        BaiqiAgentDto dto = remoteBaiqiAgentService.findBaiqiAgentById(agentId);
        if (null == dto || null == dto.getId()) {
            throw new QihoManagerException("代理商Id不存在");
        }

        if (null != remoteBaiqiAgentService.findByAgentId(agentId)) {
            throw new QihoManagerException("该代理商已存在");
        }

        String appKey = agentId.toString();
        if (null != remoteMerchantService.findByAppKey(APP_KEY_AGENT_PREFIX + appKey)) {
            throw new QihoManagerException("APPkey已存在");
        }

        OpenInterfaceDto openInterfaceDto = new OpenInterfaceDto();
        openInterfaceDto.setInterfaceType(OpenInterfaceTypeEnum.AGENT.getType());
        openInterfaceDto.setMerchantId(agentId);
        openInterfaceDto.setAppkey(APP_KEY_AGENT_PREFIX + appKey);
        openInterfaceDto.setAppsecret(AppSecretUtil.getAppSecret());
        openInterfaceDto.setGmtCreate(new Date());
        openInterfaceDto.setGmtModified(new Date());

        return (remoteMerchantService.saveOpenInterface(openInterfaceDto));
    }

    @Override
    public List<MerchantSimpleVO> findNoOpenInterface(String merchantName) {
        List<MerchantSimpleDto> noOpenInterface = remoteMerchantService.findNoOpenInterface(merchantName);
        return BeanUtils.copyList(noOpenInterface, MerchantSimpleVO.class);
    }

    @Override
    public OpenInterfaceDto checkedAppKey(String appKey, String appSecret) {
        return remoteMerchantService.checkedAppKey(appKey, appSecret);
    }

    @Override
    public Boolean updateMerchantVersion(String versionSign, Long id) {
        return remoteMerchantService.updateVersionSign(versionSign, id);
    }

}
