/**
 * Project Name:qiho-manager-biz File Name:PostsaleServiceImpl.java Package Name:com.qiho.manager.biz.service.impl
 * Date:2017年6月12日下午6:56:52 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.remoteservice.postsale.RemotePostsaleService;
import com.qiho.manager.biz.service.PostsaleService;
import com.qiho.manager.common.exception.QihoManagerException;

/**
 * ClassName:PostsaleServiceImpl <br/>
 * 售后服务实现类. <br/>
 * Date: 2017年6月12日 下午6:56:52 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class PostsaleServiceImpl implements PostsaleService {

    @Autowired
    private RemotePostsaleService remotePostsaleService;

    @Override
    public void postsaleSuccess(String orderId) {
        DubboResult<Void> result = remotePostsaleService.postsaleSuccess(orderId);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
    }

}
