package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;
import com.qiho.center.api.remoteservice.RemoteTabService;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.manager.biz.service.TabService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.TabVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2017/8/31.
 */
@Service
public class TabServiceImpl implements TabService {

    private static final String DEFAULT_TAB_STYLE_CONFIG = "{\"tabStyleId\":1}";

    @Resource
    RemoteTabService remoteTabService;

    @Override
    public DubboResult<Integer> add(TabDto tabDto) {
        return remoteTabService.add(tabDto);
    }

    @Override
    public DubboResult<Integer> deleteList(List<Long> ids) {
        return remoteTabService.deleteList(ids);
    }

    @Override
    public DubboResult<Integer> update(TabDto tabDto) {
        return remoteTabService.update(tabDto);
    }

    @Override
    public TabVO queryDetail(Long id) {
        DubboResult<TabDto> tabDto = remoteTabService.queryDetail(id);
        TabVO tabVO = BeanUtils.copy(tabDto.getResult(),TabVO.class);
        if(tabDto.getResult()!=null){
            if(tabDto.getResult().getStatus().equals("0")){
                tabVO.setStatus(true);
            }else{
                tabVO.setStatus(false);
            }
        }
        return tabVO;
    }

    @Override
    public Pagenation<TabVO> queryList() {
        DubboResult<PagenationDto<TabDto>> dubboResult = remoteTabService.queryList();
        List<TabVO> vos = Lists.newArrayList();
        List<TabDto> dtos =  dubboResult.getResult().getList();
        if(dtos!=null){
            for (TabDto dto : dtos) {
                TabVO tabVO = BeanUtils.copy(dto,TabVO.class);
                if(dto!=null){
                    if(dto.getStatus().equals("0")){
                        tabVO.setStatus(true);
                    }else{
                        tabVO.setStatus(false);
                    }
                    // 转换tab样式配置格式为JSONObject对象
                    String tabStyleConfig = dto.getTabStyleConfig();
                    tabVO.setTabStyleConfig(JSONUtil.strToJSON(StringUtils.isNotEmpty(tabStyleConfig) ?
                            tabStyleConfig : DEFAULT_TAB_STYLE_CONFIG));
                }
                vos.add(tabVO);
            }
        }
        Pagenation<TabVO> pagenation = new Pagenation<>();
        pagenation.setList(vos);
        return pagenation;
    }

    @Override
    public DubboResult<Boolean> sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        return remoteTabService.sortByPayLoad(sortId,startPayload,endPayload);
    }
}
