package com.qiho.manager.biz.service.merchant;

import com.qiho.manager.biz.params.merchant.MerchantAdvertSaveParam;
import com.qiho.manager.biz.vo.SelectVO;
import com.qiho.manager.biz.vo.merchant.MerchantAdvertVO;

import java.util.Date;
import java.util.List;

/**
 * @author peanut.huang
 * @date 2018/1/2.
 */
public interface MerchantAdvertService {

    /**
     * 列出所有商家与推啊广告同步信息
     *
     * @param merchantId  商家id
     * @return
     */
    List<MerchantAdvertVO> listAllAdvert(Long merchantId);

    /**
     * 列出所有关联了广告主的商家的广告消耗
     *
     * @param merchantId  商家id
     * @param dateStart   时间起
     * @param dateEnd     时间止
     * @return
     */
    List<MerchantAdvertVO> listAdvertConsume(Long merchantId, Date dateStart, Date dateEnd);

    /**
     * 列出未与商家关联的广告主
     *
     * @return
     */
    List<SelectVO> listUnlinkedAdvert();

    /**
     * 保存关联
     *
     * @param saveParam
     * @return
     */
    Boolean saveLink(MerchantAdvertSaveParam saveParam);
}
