package com.qiho.manager.biz.service.order;

import java.util.List;

import com.qiho.center.api.params.user.UserEvaluatePagingParams;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.order.UserEvaluatePagingVO;

/**
 * 用户评价
 *
 * @author peanut.huang
 * @date 2018/6/6.
 */
public interface UserEvaluateService {

    /**
     * 分页查询用户评价
     *
     * @param pagingParam  分页参数
     * @return
     */
    Pagenation<UserEvaluatePagingVO> findPaging(UserEvaluatePagingParams pagingParam);

    /**
     * 查询列表导出内容
     *
     * @param pagingParam 分页参数
     * @return
     */
    List<UserEvaluatePagingVO> findExportList(UserEvaluatePagingParams pagingParam);
}
