package com.qiho.manager.biz.service.ordertmp;

import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpDetailVO;
import com.qiho.manager.biz.vo.ordertmp.OrderTmpVO;

import java.util.Map;

/** 临时订单相关服务接口
 * @author chensong
 * @create 2018-05-17 15:29
 **/
public interface OrderTmpService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    Pagenation<OrderTmpVO> queryOrderTmpPage(OrderTmpPageParam param);

    /**
     * 临时订单变成有效
     * @param orderId
     * @return
     */
    boolean toValid(String orderId);

    /**
     * 提交临时订单导出任务
     * @param param
     * @return
     */
    Map<String, Object> submitOrderExport(OrderTmpPageParam param);

    /**
     * 获取订单详情
     * @param orderId
     * @return
     */
    OrderTmpDetailVO getDetail(String orderId);



}
