package com.qiho.manager.biz.service.page;

import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.manager.biz.params.page.LandPageSaveParam;
import com.qiho.manager.biz.params.page.PageSaveParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.page.PageEditVO;
import com.qiho.manager.biz.vo.page.PagePagingVO;

import java.util.List;

/**
 * @author peanut.huang
 * @date 2018/2/24.
 */
public interface PageService {

    /**
     * 百奇页面分页列表展示
     *
     * @param pageName   页面名称
     * @param pageTypes   页面类型 {@link PageTypeEnum#value}
     * @param pageTypes   页面类型 {@link PageTypeEnum#value}
     * @param tabName
     * @param pageSize   每页条数
     * @return
     */
    Pagenation<PagePagingVO> find4Paging(String pageName, List<Integer> pageTypes, String tabName,Integer offset, Integer pageSize);

    /**
     * 页面保存
     *
     * @param operatorName   操作人
     * @param pageSaveParam  保存参数
     * @return
     */
    void savePage(String operatorName, PageSaveParam pageSaveParam);

    /**
     * 根据页面id查询页面实体
     *
     * @param pageId 页面id
     * @return
     */
    PageEditVO findById(Long pageId);


    /**
     * 根据页面id查询页面实体
     *
     * @param pageId 页面id
     * @param pageTypes 页面类型
     * @return
     */
    Pagenation<PagePagingVO> findByPageId(Long pageId, List<Integer> pageTypes);

    /**
     * 保存我的落地页
     *
     * @param landPageSaveParam
     * @return
     */
    boolean saveLandPage(LandPageSaveParam landPageSaveParam);
}
