package com.qiho.manager.biz.service.template;

import com.qiho.center.api.params.template.TemplateParams;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.TemplateVO;
import com.qiho.manager.common.param.TemplatePageParam;


/**
 * @author Wangpf
 * @description  短信模板业务
 * @date 2019/9/12 5:44 PM
 */
public interface TemplateService {

    /**
     * 根据条件查询短信模板
     *
     * @return
     */
    Pagenation<TemplateVO> findTemplateByParam(TemplatePageParam templatePageParam);

    /**
     * 新增短信模板
     *
     * @param templateParams 短信模板参数
     * @return
     */
    boolean  addTemplate(TemplateParams templateParams);

    /**
     * 更新短信模板信息
     *
     * @param templateParams
     * @return
     */
    boolean updateTemplate(TemplateParams templateParams);

}
