/**
 * Project Name:qiho-web-biz File Name:OrderDetailVO.java Package Name:com.qiho.web.biz.vo Date:2017年6月5日下午4:41:56
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import com.qiho.manager.biz.vo.coupon.CouponOrderVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * ClassName:OrderDetailVO <br/>
 * 订单详情. <br/>
 * Date: 2017年6月5日 下午4:41:56 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel(value = "订单详情展示对象")
public class OrderDetailVO {

    @ApiModelProperty("订单基本信息")
    private OrderVO           order;

    @ApiModelProperty("订单商品详情")
    private OrderItemVO       orderItem;

    @ApiModelProperty("资金流水")
    private List<FundVO>      fundList;

    @ApiModelProperty("ERP订单信息")
    private List<ErpOrderVO>  erpOrderList;

    @ApiModelProperty("物流信息")
    private List<LogisticsVO> logisticsList;

    @ApiModelProperty("防作弊命中规则")
    private List<String>      anticheateList;

    @ApiModelProperty("渠道信息")
    private ChannelInfoVO     channelInfo;

    @ApiModelProperty("皮肤信息")
    private OrderSkinVO skinItem;

    @ApiModelProperty("售后子订单")
    private List<AfterSaleVO> afterSaleList;

    @ApiModelProperty("优惠券子订单")
    private List<CouponOrderVO> couponList;

    public List<CouponOrderVO> getCouponList() {
        return couponList;
    }

    public void setCouponList(List<CouponOrderVO> couponList) {
        this.couponList = couponList;
    }

    /**
     * order.
     *
     * @return the order
     */
    public OrderVO getOrder() {
        return order;
    }

    /**
     * order.
     *
     * @param order the order to set
     */
    public void setOrder(OrderVO order) {
        this.order = order;
    }

    /**
     * orderItem.
     *
     * @return the orderItem
     */
    public OrderItemVO getOrderItem() {
        return orderItem;
    }

    /**
     * orderItem.
     *
     * @param orderItem the orderItem to set
     */
    public void setOrderItem(OrderItemVO orderItem) {
        this.orderItem = orderItem;
    }

    /**
     * fundList.
     *
     * @return the fundList
     */
    public List<FundVO> getFundList() {
        return fundList;
    }

    /**
     * fundList.
     *
     * @param fundList the fundList to set
     */
    public void setFundList(List<FundVO> fundList) {
        this.fundList = fundList;
    }

    /**
     * erpOrderList.
     *
     * @return the erpOrderList
     */
    public List<ErpOrderVO> getErpOrderList() {
        return erpOrderList;
    }

    /**
     * erpOrderList.
     *
     * @param erpOrderList the erpOrderList to set
     */
    public void setErpOrderList(List<ErpOrderVO> erpOrderList) {
        this.erpOrderList = erpOrderList;
    }

    /**
     * logisticsList.
     *
     * @return the logisticsList
     */
    public List<LogisticsVO> getLogisticsList() {
        return logisticsList;
    }

    /**
     * logisticsList.
     *
     * @param logisticsList the logisticsList to set
     */
    public void setLogisticsList(List<LogisticsVO> logisticsList) {
        this.logisticsList = logisticsList;
    }

    /**
     * anticheateList.
     *
     * @return the anticheateList
     */
    public List<String> getAnticheateList() {
        return anticheateList;
    }

    /**
     * anticheateList.
     *
     * @param anticheateList the anticheateList to set
     */
    public void setAnticheateList(List<String> anticheateList) {
        this.anticheateList = anticheateList;
    }

    /**
     * channelInfo.
     *
     * @return the channelInfo
     */
    public ChannelInfoVO getChannelInfo() {
        return channelInfo;
    }

    /**
     * channelInfo.
     *
     * @param channelInfo the channelInfo to set
     */
    public void setChannelInfo(ChannelInfoVO channelInfo) {
        this.channelInfo = channelInfo;
    }

    public OrderSkinVO getSkinItem() {
        return skinItem;
    }

    public void setSkinItem(OrderSkinVO skinItem) {
        this.skinItem = skinItem;
    }

    public List<AfterSaleVO> getAfterSaleList() {
        return afterSaleList;
    }

    public void setAfterSaleList(List<AfterSaleVO> afterSaleList) {
        this.afterSaleList = afterSaleList;
    }
}
