/**
 * Project Name:qiho-manager-biz File Name:OrderVO.java Package Name:com.qiho.manager.biz.vo Date:2017年6月2日下午1:45:37
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:OrderVO <br/>
 * Date: 2017年6月2日 下午1:45:37 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("订单展示对象")
public class OrderSnapshotVO {

    @ApiModelProperty("订单ID")
    private String  orderId;

    @ApiModelProperty("订单详情页URL")
    private String  orderDetailUrl;

    @ApiModelProperty("创建时间，格式：yyyy-MM-dd HH:mm:ss")
    private String  gmtCreate;

    @ApiModelProperty("订单状态")
    private String  orderStatus;

    @ApiModelProperty("商品图片")
    private String  image;

    @ApiModelProperty("商品ID")
    private Long    itemId;

    @ApiModelProperty("规格，属性值组合，例：白色,XXL")
    private String  skuName;

    @ApiModelProperty("商品标题")
    private String  itemName;

    @ApiModelProperty("商品价格")
    private Integer sellingPrice;

    @ApiModelProperty("商品件数")
    private Integer quantity;

    @ApiModelProperty("付款方式")
    private String  payType;

    @ApiModelProperty("资金状态,TO_PAY-待付款/SUCCESS-付款成功/FAILED-付款失败")
    private String  fundStatus;

    @ApiModelProperty("订单金额")
    private Integer amt;

    @ApiModelProperty("买家姓名")
    private String  consumerName;

    @ApiModelProperty("手机号")
    private String  mobile;

    @ApiModelProperty("省/直辖市")
    private String  province;

    @ApiModelProperty("市")
    private String  city;

    @ApiModelProperty("区县")
    private String  district;

    @ApiModelProperty("详细地址")
    private String  address;

    @ApiModelProperty("物流公司名称")
    private String  logisticsName;

    @ApiModelProperty("物流状态，具体由物流公司定义")
    private String  logisticsStatus;

    @ApiModelProperty("物流单号")
    private String  postId;

    @ApiModelProperty("买家留言")
    private String  message;

    @ApiModelProperty("命中的踢单规则")
    private String anticheatRules;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * orderDetailUrl.
     *
     * @return the orderDetailUrl
     */
    public String getOrderDetailUrl() {
        return orderDetailUrl;
    }

    /**
     * orderDetailUrl.
     *
     * @param orderDetailUrl the orderDetailUrl to set
     */
    public void setOrderDetailUrl(String orderDetailUrl) {
        this.orderDetailUrl = orderDetailUrl;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public String getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public String getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * image.
     *
     * @return the image
     */
    public String getImage() {
        return image;
    }

    /**
     * image.
     *
     * @param image the image to set
     */
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * itemId.
     *
     * @return the itemId
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * itemId.
     *
     * @param itemId the itemId to set
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * skuName.
     *
     * @return the skuName
     */
    public String getSkuName() {
        return skuName;
    }

    /**
     * skuName.
     *
     * @param skuName the skuName to set
     */
    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * sellingPrice.
     *
     * @return the sellingPrice
     */
    public Integer getSellingPrice() {
        return sellingPrice;
    }

    /**
     * sellingPrice.
     *
     * @param sellingPrice the sellingPrice to set
     */
    public void setSellingPrice(Integer sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    /**
     * quantity.
     *
     * @return the quantity
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * quantity.
     *
     * @param quantity the quantity to set
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * payType.
     *
     * @return the payType
     */
    public String getPayType() {
        return payType;
    }

    /**
     * payType.
     *
     * @param payType the payType to set
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    /**
     * fundStatus.
     *
     * @return the fundStatus
     */
    public String getFundStatus() {
        return fundStatus;
    }

    /**
     * fundStatus.
     *
     * @param fundStatus the fundStatus to set
     */
    public void setFundStatus(String fundStatus) {
        this.fundStatus = fundStatus;
    }

    /**
     * amt.
     *
     * @return the amt
     */
    public Integer getAmt() {
        return amt;
    }

    /**
     * amt.
     *
     * @param amt the amt to set
     */
    public void setAmt(Integer amt) {
        this.amt = amt;
    }

    /**
     * consumerName.
     *
     * @return the consumerName
     */
    public String getConsumerName() {
        return consumerName;
    }

    /**
     * consumerName.
     *
     * @param consumerName the consumerName to set
     */
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    /**
     * mobile.
     *
     * @return the mobile
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * mobile.
     *
     * @param mobile the mobile to set
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * province.
     *
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * district.
     *
     * @return the district
     */
    public String getDistrict() {
        return district;
    }

    /**
     * district.
     *
     * @param district the district to set
     */
    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * address.
     *
     * @param address the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * logisticsName.
     *
     * @return the logisticsName
     */
    public String getLogisticsName() {
        return logisticsName;
    }

    /**
     * logisticsName.
     *
     * @param logisticsName the logisticsName to set
     */
    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    /**
     * logisticsStatus.
     *
     * @return the logisticsStatus
     */
    public String getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * logisticsStatus.
     *
     * @param logisticsStatus the logisticsStatus to set
     */
    public void setLogisticsStatus(String logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    /**
     * postId.
     *
     * @return the postId
     */
    public String getPostId() {
        return postId;
    }

    /**
     * postId.
     *
     * @param postId the postId to set
     */
    public void setPostId(String postId) {
        this.postId = postId;
    }

    /**
     * message.
     *
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     *
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    public String getAnticheatRules() {
        return anticheatRules;
    }

    public void setAnticheatRules(String anticheatRules) {
        this.anticheatRules = anticheatRules;
    }
}
