package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * Created by danke on 2017/6/23.
 */
@ApiModel(value = "踢单策略展示对象")
public class OrderStrategyVO implements Serializable {

    /**
     * 策略id
     */
    @ApiModelProperty(value = "策略ID")
    private Long id;
    /**
     * 策略名称
     */
    @ApiModelProperty(value = "策略name")
    private String name;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "策略创建人")
    private String creator;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "策略创建时间")
    private String gmtCreate;
    /**
     * 更新人
     */
    @ApiModelProperty(value = "策略更新人")
    private String updator;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "策略更新时间")
    private String gmtModified;
    /**
     * 命中后处理链路的key,前段展示时这边改为中文
     * @return
     */
    @ApiModelProperty(value = "策略命中处理行为name")
    private String handlerName;

    @ApiModelProperty(value = "动态验证码")
    private String code;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "策略类型")
    private Integer strategyType;
    /**
     * 规则DTO
     * @return
     */
    private List<StrategyRuleVo> strategyRuleVos;

    @ApiModelProperty(value = "策略适用类型：0 全部商家，1部分商家")
    private Integer useType;

    @ApiModelProperty(value = "商家id集，例：1,2,3")
    private String ids;

    @ApiModelProperty(value = "商家id与名称集")
    private List<SelectVO> merchants;

    @ApiModelProperty(value = "提醒文案")
    private String alertText;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }


    public String getUpdator() {
        return updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public String getHandlerName() {
        return handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public List<StrategyRuleVo> getStrategyRuleVos() {
        return strategyRuleVos;
    }

    public void setStrategyRuleVos(List<StrategyRuleVo> strategyRuleVos) {
        this.strategyRuleVos = strategyRuleVos;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(Integer strategyType) {
        this.strategyType = strategyType;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public List<SelectVO> getMerchants() {
        return merchants;
    }

    public void setMerchants(List<SelectVO> merchants) {
        this.merchants = merchants;
    }

    public String getAlertText() {
        return alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }
}
