package com.qiho.manager.biz.vo.orderexport;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 订单导出模板
 *
 * @author peanut.huang
 * @date 2017/11/24.
 */
@ApiModel("订单导出模板对象")
public class OrderExportTemplateVO {

    @ApiModelProperty("模板id")
    private Long id;

    @ApiModelProperty("模板名称")
    private String tempName;

    @ApiModelProperty("模板字段内容")
    private String tempFields;


    public OrderExportTemplateVO() {
        super();
    }

    /**
     * get id
     *
     * @return the template id
     */
    public Long getId() {
        return id;
    }

    /**
     * set id
     *
     * @param id the template id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * get template name
     *
     * @return the template name
     */
    public String getTempName() {
        return tempName;
    }

    /**
     * set template name
     *
     * @param tempName the template name
     */
    public void setTempName(String tempName) {
        this.tempName = tempName;
    }

    /**
     * get template fields
     * @return  the template fields
     */
    public String getTempFields() {
        return tempFields;
    }

    /**
     * set template fields
     *
     * @param tempFields  the template fields
     */
    public void setTempFields(String tempFields) {
        this.tempFields = tempFields;
    }

    @Override
    public String toString() {
        return "OrderExportTemplateVO{" +
                "id=" + id +
                ", tempName='" + tempName + '\'' +
                ", tempFields='" + tempFields + '\'' +
                '}';
    }
}

