package com.qiho.manager.biz.vo.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.alibaba.fastjson.JSONObject;

/**
 * @author jiafeng.geng
 * @date 2018-07-18.
 */
@ApiModel("集合页商品展示对象")
public class CollItemVO {

    @ApiModelProperty("商品ID")
    private Long id;

    @ApiModelProperty("商品标题")
    private String itemName;

    @ApiModelProperty("商品图片")
    private String image;

    @ApiModelProperty("商品在当前集合页的状态, 0-关闭/1-开启")
    private Integer collItemStatus;

    @ApiModelProperty("商品的状态, OFF-关闭/ON-开启")
    private String itemStatus;

    @ApiModelProperty("商品的总库存")
    private Long stock;

    @ApiModelProperty("商品样式配置, skinId或pid的值")
    private JSONObject styleConfig;

    @ApiModelProperty("商品样式对应的名称")
    private String styleName;

    @ApiModelProperty("排序值, 数值越大排序越靠前")
    private Integer sort;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getCollItemStatus() {
        return collItemStatus;
    }

    public void setCollItemStatus(Integer collItemStatus) {
        this.collItemStatus = collItemStatus;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public JSONObject getStyleConfig() {
        return styleConfig;
    }

    public void setStyleConfig(JSONObject styleConfig) {
        this.styleConfig = styleConfig;
    }

    public String getStyleName() {
        return styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
