package com.qiho.manager.biz.vo.page;

import com.qiho.center.api.enums.page.PageTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 百奇页面分页列表VO
 *
 * @author peanut.huang
 * @date 2018/2/24.
 */
@ApiModel("页面分页列表展示对象")
public class PagePagingVO {


    @ApiModelProperty("页面id")
    private Long id;

    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面效果图地址")
    private String pageImg;

    @ApiModelProperty("最后操作人")
    private String operatorName;

    @ApiModelProperty("页面创建时间")
    private String gmtCreate;

    @ApiModelProperty("页面最后更新时间")
    private String gmtModified;

    /**
     * 创建人
     */
    private String createName;

    /**
     * 页面地址
     */
    private String landPageUrl;

    /**
     * 页面类型 {@link PageTypeEnum#value}
     */
    private Integer pageType;

    /**
     * 页面的原生类型
     */
    private Integer originType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getPageImg() {
        return pageImg;
    }

    public void setPageImg(String pageImg) {
        this.pageImg = pageImg;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getLandPageUrl() {
        return landPageUrl;
    }

    public void setLandPageUrl(String landPageUrl) {
        this.landPageUrl = landPageUrl;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Integer getOriginType() {
        return originType;
    }

    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    @Override
    public String toString() {
        return "PagePagingVO{" +
                "id=" + id +
                ", pageName='" + pageName + '\'' +
                ", pageImg='" + pageImg + '\'' +
                ", operatorName='" + operatorName + '\'' +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
