package com.qiho.manager.biz.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 主账号参数
 * Created by sunchangji on 2017/12/11.
 */
@ApiModel("新增主账号参数对象")
public class MainAccountParam {

    @ApiModelProperty("0-商家,2-代理商")
    @NotNull
    private Integer accountType;

    @ApiModelProperty("关联id,(accountType=0则为商家id,accountType=2则为代理商id)")
    @NotNull
    private Long relationId;

    @ApiModelProperty("手机号")
    @Length(min = 11,max = 11,message = "Phone length error")
    private String mobile;

    @ApiModelProperty("账户名称")
    @NotBlank
    private String account;

    @ApiModelProperty("密码")
    @NotBlank
    private String pwd;

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }
}
