package com.qiho.manager.biz.params.component;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-07-27
 */
@ApiModel("组件页面预览参数")
@Data
public class ComponentPagePreParam {

    @ApiModelProperty("组件的列表")
    private List<ComponentSimpleParam> list;

    @ApiModelProperty("所有组件合成的配置项参数")
    private String totalConfig;

    @ApiModelProperty("组件页面的类型，3-组件化的商品详情页，4-组件化的集合页")
    private Integer pageType;

    @ApiModelProperty("js对接平台")
    private Integer jsPlatform;

    @ApiModelProperty("注意，这是原来的itemId变更的参数，预览时必传此参数，组件化商品详情页请传商品id，组件化集合页请传集合页id")
    private Long id;

    /**
     * 获取组件id集合
     * @return
     */
    public List<Long> fetchComponentIds(){
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list.stream().map(ComponentSimpleParam::getComponentId).collect(Collectors.toList());
    }

}
