package com.qiho.manager.biz.params.component;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @author chensong
 * @create 2018-07-25
 */
@ApiModel("组件参数")
public class ComponentParam {

    @ApiModelProperty("html代码，BASE64加密后的密文")
    private String htmlCode;

    @ApiModelProperty("css代码，BASE64加密后的密文")
    private String cssCode;

    @ApiModelProperty("js代码，BASE64加密后的密文")
    private String jsCode;

    @ApiModelProperty("配置项，json串")
    private String configParam;

    @ApiModelProperty("图片Url")
    @NotBlank(message = "图片地址不能为空")
    private String image;

    @ApiModelProperty("组件名称")
    @NotBlank(message = "组件名称不能为空")
    private String componentName;

    @ApiModelProperty("组件类型")
    @NotNull(message = "组件类型不能为空")
    private Integer componentType;

    @ApiModelProperty("id")
    private Long id;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHtmlCode() {
        return htmlCode;
    }

    public void setHtmlCode(String htmlCode) {
        this.htmlCode = htmlCode;
    }

    public String getCssCode() {
        return cssCode;
    }

    public void setCssCode(String cssCode) {
        this.cssCode = cssCode;
    }

    public String getJsCode() {
        return jsCode;
    }

    public void setJsCode(String jsCode) {
        this.jsCode = jsCode;
    }

    public String getConfigParam() {
        return configParam;
    }

    public void setConfigParam(String configParam) {
        this.configParam = configParam;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Integer getComponentType() {
        return componentType;
    }

    public void setComponentType(Integer componentType) {
        this.componentType = componentType;
    }
}
