package com.qiho.manager.biz.process.component;

import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import org.springframework.stereotype.Component;

import java.util.EnumMap;
import java.util.Map;

/**
 * 组件化页面处理器的决策者
 *
 * @author chensong
 * @create 2018-09-20
 */
@Component
public class ComponentPageDecider {

    /**
     * {@link PageTypeEnum} 与 {@link ComponentPageProcessor} 映射Map
     */
    private static Map<PageTypeEnum, ComponentPageProcessor> componentPageMap =  new EnumMap<>(PageTypeEnum.class);


    /**
     * 获取组件化页面处理者
     * @param pageType
     * @return
     */
    public static ComponentPageProcessor getProcessor(PageTypeEnum pageType){
        return componentPageMap.get(pageType);
    }


    /***
     * 注册组件化页面处理器
     * @param pageType
     * @param processor
     */
    public static void registerPorcessor(PageTypeEnum pageType, ComponentPageProcessor processor){
        if (pageType == null || processor == null) {
            throw new QihoManagerException("组件化页面处理器注册失败，参数出现null");
        }
        componentPageMap.put(pageType, processor);
    }


}
