package com.qiho.manager.biz.runnable;

import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * Created by liuyao on 2017/6/8.
 * 订单处理策略接口(单例)
 *
 */
public interface AbstractOrderHandler<T>{

    /**
     * 将文件中的一行String转成Dto对象(即解析策略)
     * @param row 行
     * @param status 改变的状态
     * @return
     */
    T transform(String row, String status);
    
    /**
     * 将文件中的一行String转成Dto对象(即解析策略)
     * @param row 行
     * @return
     */
    T transform(String row);

    /**
     * 注入任务(执行策略)
     * @param cacheKey
     * @param list
     * @return 提交的有效条数
     */
    Integer exeTask(String cacheKey,List<T> list);
    /**
     * 注入任务(执行策略)
     * @param cacheKey
     * @param list
     * @return 提交的有效条数
     */
    Integer exeTask(String cacheKey, List<T> list, JSONObject extraParams);
}
