package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.api.remoteservice.ordertmp.RemoteOrderTmpService;
import com.qiho.manager.biz.params.OrdersTempExportParam;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.UploadTool;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/** 临时订单导runnable
 * @author chensong
 * @create 2018-05-21 19:55
 **/
@Component
@Scope("prototype")
public class OrderTmpExportRunnable extends BaseExportRunnable implements Runnable  {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderTmpExportRunnable.class);

    private static final int ORDER_EXPORT_MAX = 1000;

    @Autowired
    private RemoteOrderTmpService remoteOrderTmpService;

    private OrderTmpPageParam pageParam;


    private File file;

    private String filePath = "orders/";

    private Long taskId = System.currentTimeMillis();



    /**
     * 初始化
     * @return 任务号
     */
    public Map<String,Object> init(){
        file = super.getFile2(filePath);
        return super.init(file,taskId);
    }

    @Override
    public void run() {

        int count = remoteOrderTmpService.countPageQuery(pageParam);
        int batch = getBatchs(count);

        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey(taskId);
        HashOperations<String,String,Object> operations = redisTemplate.opsForHash();
        Workbook workbook = null;
        try(FileOutputStream outputStream = new FileOutputStream(file)){
            List<OrdersTempExportParam> exportList = Lists.newArrayList();
            for(int i=0; i<batch; i++){
                pageParam.setOffset(i*ORDER_EXPORT_MAX);
                PagenationDto<OrderTmpDetailDto> result = remoteOrderTmpService.queryOrderTmpPage(pageParam);
                List<OrdersTempExportParam> list = transferExcelEntity(result);
                exportList.addAll(list);
                operations.increment(key,"successCount",list.size());
            }
            workbook = ExcelExportUtil.exportBigExcel(new ExportParams(),OrdersTempExportParam.class,exportList);
            workbook.write(outputStream);
            operations.put(key,"message","文件上传中");
            String url = UploadTool.uploadOssNotCDN(file,
                    filePath+file.getName(),"application/x-msdownload;charset=GBK");

            operations.put(key,"url",url);
            operations.put(key,"message","导出成功");
        } catch (Exception e) {
            LOGGER.error("orders Export error msg={}",e);
            operations.put(key, "message", e.getMessage());
        } finally {
            operations.put(key, "success", "true");
            ExcelExportUtil.closeExportBigExcel();
            try {
                workbook.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (file != null && file.exists() && !file.delete()) {
                LOGGER.warn("file delete error or file not exists");
            }
        }



    }

    /**
     * 转换成Excel导出的格式
     * @param result
     * @return
     */
    private List<OrdersTempExportParam> transferExcelEntity(PagenationDto<OrderTmpDetailDto> result){

        List<OrdersTempExportParam> list = Lists.newArrayList();
        for (OrderTmpDetailDto dto : result.getList()) {
            OrdersTempExportParam ordersExport = BeanUtils.copy(dto, OrdersTempExportParam.class);
            ordersExport.setOrderAmt(dto.getOrderAmt() / 100.0);
            if (dto.getDeliveryEnum() == null) {
                ordersExport.setDelivery("");
            } else {
                ordersExport.setDelivery(dto.getDeliveryEnum().getDesc());
            }
            ordersExport.setOrderStatus(dto.getOrderStatusEnum().getDesc());
            ordersExport.setSellingPrice(dto.getSellingPrice() / 100.0);
            ordersExport.setAnticheatRules(String.join(",",dto.getAnticheatRules()));
            list.add(ordersExport);
        }

        return list;
    }



    private int getBatchs(int total){
        return total%ORDER_EXPORT_MAX==0?total/ORDER_EXPORT_MAX:(total/ORDER_EXPORT_MAX+1);
    }

    public OrderTmpPageParam getPageParam() {
        return pageParam;
    }

    public void setPageParam(OrderTmpPageParam pageParam) {
        pageParam.setMax(ORDER_EXPORT_MAX);
        pageParam.setOffset(0);
        this.pageParam = pageParam;
    }
}
