package com.qiho.manager.biz.runnable.ordertaskhandler;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;

/**
 * Created by liuyao on 2017/6/14.
 * 批量发货失败
 */
@Service
public class ErpOrderDeliverToFailedHandler implements AbstractOrderHandler<BatchResolveErpDeliverParams> {

    private  Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;

    @Override
    public BatchResolveErpDeliverParams transform(String row, String status) {
        List<String> list = splitter.splitToList(row);
        BatchResolveErpDeliverParams params = new BatchResolveErpDeliverParams();
        params.setErpId(list.get(0));
        params.setDealResult(BatchResolveErpDeliverParams.DEAL_RESULT_FAILD);
        return params;
    }

    @Override
    public BatchResolveErpDeliverParams transform(String row) {
        return transform(row,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list) {
        DubboResult<Integer> result = remoteErpOrderService.batchResolveErpDeliver(cacheKey,list);
        return result.getResult();
    }

    @Override
    public Integer exeTask(String cacheKey, List<BatchResolveErpDeliverParams> list, JSONObject extraParams) {
        return exeTask(cacheKey,list);
    }




}
