package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 
 * ClassName: ErpOrderReviewToFaildHandler <br/>
 * Function: 批量审核失败. <br/>
 * date: 2017年6月21日 下午2:25:25 <br/>
 *
 * @author chencheng
 * @version
 */
@Service
public class ErpOrderReviewToFaildHandler implements AbstractOrderHandler<ErpOrderDto> {

    private Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings().limit(2);
    private String remarks = "旺店通审核失败-";
   
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;

    @Override
    public ErpOrderDto transform(String row, String status) {
        ErpOrderDto erpOrderDto = new ErpOrderDto();
        List<String> list = splitter.splitToList(row);
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank(list.get(0))) {
            return null;
        }
        erpOrderDto.setErpId(list.get(0));
        if (list.size()>1) {
            erpOrderDto.setFailedMessage(remarks+list.get(1));
        }
        erpOrderDto.setErpStatus(ErpStatusEnum.FAILED.getCode());
        return erpOrderDto;
    }

    @Override
    public ErpOrderDto transform(String row) {
        return transform(row,null);
    }
    
    @Override
    public Integer exeTask(String cacheKey, List<ErpOrderDto> list) {
        DubboResult<Integer> result = remoteErpOrderService.batchReviewFaildErpOrder(cacheKey,list);
        return result.getResult();
    }

    @Override
    public Integer exeTask(String cacheKey, List<ErpOrderDto> list, JSONObject extraParams) {
        return exeTask(cacheKey, list);
    }
}
