package com.qiho.manager.biz.runnable.ordertaskhandler;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;

/**
 * ClassName: LogisticsOrderSignHandler <br/>
 * Function: 批量物流订单签收策略. <br/>
 * date: 2017年6月14日 上午11:44:03 <br/>
 *
 * @author chencheng
 * @version
 */
@Service
public class LogisticsOrderSignHandler implements AbstractOrderHandler<LogisticsOrderDto> {

    @Autowired
    private RemoteLogisticsOrderService remoteLogisticsOrderService;

    private static final Logger         LOG      = LoggerFactory.getLogger(LogisticsOrderSignHandler.class);

    private Splitter                    splitter = Splitter.on(",").trimResults().omitEmptyStrings().limit(3);

    @Override
    public LogisticsOrderDto transform(String row, String status) {
        LogisticsOrderDto params = new LogisticsOrderDto();
        try {
            List<String> line = splitter.splitToList(row);
            if (line.size() < 2) {
                return null;
            }
            if (StringUtils.equals(status, LogisticsOrderStatusEnum.FAILED.getCode())) {
                params.setLogisticsStatus(YTOLogisticsStatusEnum.FAILED.getDesc());
            } else if (StringUtils.equals(status, LogisticsOrderStatusEnum.SUCCESS.getCode())) {
                params.setLogisticsStatus(YTOLogisticsStatusEnum.SIGNED.getDesc());
            } else {
                return null;
            }
            params.setLogisticsName(line.get(0));
            params.setPostId(line.get(1));
            params.setOrderStatus(status);
            return params;
        } catch (Exception e) {
            LOG.info("批量订单签收文件行解析失败={}", e, row);
            return null;
        }

    }

    @Override
    public LogisticsOrderDto transform(String row) {
        return transform(row,null);
    }
    
    
    @Override
    public Integer exeTask(String cacheKey, List<LogisticsOrderDto> list) {
        return exeTask(cacheKey,list,null);
    }
    
    @Override
    public Integer exeTask(String cacheKey, List<LogisticsOrderDto> list, JSONObject extraParams) {
        List<LogisticsOrderDto> newList = Lists.newArrayList();
        for (LogisticsOrderDto it : list) {
            if (it != null && !Objects.equal(null, it.getPostId()) && !Objects.equal(null, it.getLogisticsName())) {
                newList.add(it);
            }
        }
        DubboResult<Integer> result = remoteLogisticsOrderService.batchSignOrder(cacheKey, newList);
        return result.getResult();
    }
}
