package com.qiho.manager.biz.runnable.ordertaskhandler;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;

/**
 * Created by liuyao on 2017/6/9.
 * 批量审核订单策略
 */
@Service
public class OrderAuditHandler implements AbstractOrderHandler<OrderAuditParams> {
    @Autowired
    private RemoteOrderService remoteOrderService;

    private Logger logger = LoggerFactory.getLogger(OrderAuditHandler.class);

    private Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings().limit(3);

    @Override
    public OrderAuditParams transform(String row, String status) {
        OrderAuditParams params = new OrderAuditParams();
        try {
            List<String> line = splitter.splitToList(row);
            if(line.size()<2){
                return null;
            }
            Integer auditResult = Integer.valueOf(line.get(1));
            params.setOrderId(line.get(0));
            params.setAuditResult(auditResult);
            if(line.size()==3){
                params.setRemark(line.get(2));
            }
            return params;
        }catch (Exception e){
            logger.info("审核订单行解析失败={}",e,row);
            return null;
        }

    }
    
    @Override
    public OrderAuditParams transform(String row) {
        return transform(row,null);
    }
    
    @Override
    public Integer exeTask(String cacheKey, List<OrderAuditParams> list) {
        return exeTask(cacheKey,list,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<OrderAuditParams> list, JSONObject extraParams) {
        List<OrderAuditParams> newList = Lists.newArrayList();
        for(OrderAuditParams it:list){
            if(it!=null&& !Objects.equal(null,it.getOrderId())&& !Objects.equal(null,it.getAuditResult())){
                newList.add(it);
            }
        }
        //DubboResult<Integer> result = remoteOrderService.batchAuditOrder(cacheKey,list);
        return 0;
    }

}
