/**
 * Project Name:qiho-manager-biz
 * File Name:ItemPropertyService.java
 * Package Name:com.qiho.manager.biz.service
 * Date:2017年5月23日上午11:36:46
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.manager.biz.service;

import com.qiho.center.api.dto.SkuPropertyValueDto;

import java.util.List;
import java.util.Map;

/**
 * ClassName:ItemPropertyService <br/>
 * Date:     2017年5月23日 上午11:36:46 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemPropertyService {

    /**
     * 批量保存属性名
     * @author zhanglihui
     * @param propertyNameList
     * @return <id：属性名> 键值对
     */
    Map<Long, String> savePropertyName(List<String> propertyNameList);

    /**
     * 批量保存属性值
     * @author zhanglihui
     * @param propertyValueList
     * @return <id：属性值> 键值对
     */
    Map<Long, String> savePropertyValue(List<SkuPropertyValueDto> propertyValueList);

    /**
     * 根据id更新商品属性值
     * @author zhanglihui
     * @param id
     * @param propertyValue
     */
    void updatePropertyValue(Long id, String propertyValue);

    /**
     * 根据id更新商品属性名称
     *
     * @param id
     * @param propertyName
     * @author jiafeng.geng
     */
    void updatePropertyName(Long id, String propertyName);

}

