package com.qiho.manager.biz.service.account.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.constant.AccountConstant;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.api.params.account.BaiqiAccountParam;
import com.qiho.center.api.remoteservice.account.RemoteBaiqiAccountBackendService;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.params.MainAccountParam;
import com.qiho.manager.biz.service.account.BaiqiAccountService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.account.IdAndNameVO;
import com.qiho.manager.biz.vo.account.MainAccountVO;
import com.qiho.manager.common.constant.QihoConstant;
import com.qiho.manager.common.util.Md5Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by sunchangji on 2017/12/11.
 */
@Service("baiqiMainAccountService")
public class BaiqiAccountServiceImpl implements BaiqiAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiAccountServiceImpl.class);
    @Resource
    private RemoteBaiqiAccountBackendService remoteBaiqiAccountBackendService;
    @Resource
    private RemoteMerchantService remoteMerchantService;
    @Resource
    private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;

    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public List<IdAndNameVO> findRelationIdAndName(int accountType) {
        List<SimpleIdAndNameDto> idAndNameDtos = null;
        //主账号类型,则查询商家列表
        if (accountType == BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode()) {
            idAndNameDtos = remoteMerchantService.findAllIdAndNames();
        } else {
            idAndNameDtos = remoteBaiqiAgentBackendService.findAgentIdAndName();
        }

        return idAndNameDtos.stream().map(temp -> {
            IdAndNameVO idAndNameVO = new IdAndNameVO();
            idAndNameVO.setId(temp.getId());
            idAndNameVO.setName(temp.getName());
            return idAndNameVO;
        }).collect(Collectors.toList());
    }


    @Override
    public Pagenation<MainAccountVO> findPageAccount(AccountPageParam pageQueryParams) {

        buildPermissionParam(pageQueryParams);

        PagenationDto<BaiqiMainAndAgenAccountDto> pagenationDto = remoteBaiqiAccountBackendService.findPageMainAccount(pageQueryParams);
        Pagenation<MainAccountVO> page = new Pagenation<>();
        List<BaiqiMainAndAgenAccountDto> list = pagenationDto.getList();
        page.setTotal(pagenationDto.getTotal());
        if (CollectionUtils.isEmpty(list)) {
            page.setList(Collections.emptyList());
            return page;
        }
        page.setList(BeanUtils.copyList(pagenationDto.getList(), MainAccountVO.class));
        return page;
    }

    /**
     * 构建权限 参数  如果没有全局权限 只能看到自己关联的商家和账号的角色
     *
     * @param pageQueryParams
     */
    private void buildPermissionParam(AccountPageParam pageQueryParams) {
        Boolean seeAllMerchant = adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllAgent");
        if (!seeAllMerchant) {
            pageQueryParams.setOwnerAeName(RequestTool.getAdmin().getName());
        }

        boolean flag = adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllMerchant");

        if (!flag) {
            pageQueryParams.setOwnerAeId(RequestTool.getAdminId());
        }
    }

    @Override
    public String inserAccount(MainAccountParam mainAccountParam) {
        BaiqiAccountDto accountDto = BeanUtils.copy(mainAccountParam, BaiqiAccountDto.class);
        Boolean result;
        try {
            result = remoteBaiqiAccountBackendService.insertMainAccount(accountDto);
        } catch (Exception e) {
            LOGGER.warn("新增主账号失败,msg={}", e.getMessage());
            return e.getMessage();
        }
        if (result) {
            return StringUtils.EMPTY;
        }
        return "新增主账号失败";
    }

    @Override
    public String updateAccount(Long id, String mobile, String pwd) {
        BaiqiAccountParam accountParam = new BaiqiAccountParam();
        accountParam.setId(id);
        accountParam.setMobile(mobile);
        if (!pwd.equals(AccountConstant.PD_VALUE)) {
            accountParam.setPwd(Md5Util.md5WithSalt(pwd, QihoConstant.PD_SAIL));
        }
        Boolean result;
        try {
            result = remoteBaiqiAccountBackendService.updateMainAccount(accountParam);
        } catch (Exception e) {
            LOGGER.warn("更新主账号失败,msg={}", e.getMessage());
            return e.getMessage();
        }
        if (result) {
            return StringUtils.EMPTY;
        }
        return "更新主账号失败";
    }

    @Override
    public String changeAccountState(Long id, boolean state) {
        Boolean result;
        try {
            if (state) {
                result = remoteBaiqiAccountBackendService.enableMainAccount(id);
            } else {
                result = remoteBaiqiAccountBackendService.disableMainAccount(id);
            }
        } catch (Exception e) {
            LOGGER.warn("更新状态失败,msg={}", e.getMessage());
            return e.getMessage();
        }
        if (result) {
            return StringUtils.EMPTY;
        }
        return "更新主账号状态失败";

    }


}
