package com.qiho.manager.biz.service.agent.impl;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentSaveDto;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.manager.biz.params.agent.AgentSaveParam;
import com.qiho.manager.biz.service.agent.BaiqiAgentService;
import com.qiho.manager.biz.vo.AgentSimpleVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.agent.AgentVO;
import com.qiho.manager.biz.vo.merchant.SimpleMerchantVO;
import com.qiho.manager.biz.vo.merchant.SpecialSimpleVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 代理商服务
 * Author: zhanghuifeng
 * Date:   14:03 2017/12/15
 */
@Service("baiqiAgentService")
public class BaiqiAgentServiceImpl implements BaiqiAgentService {

	@Resource
	private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;

	@Autowired
	private AdminPowerCacheService adminPowerCacheService;

	@Override
	public Pagenation<AgentVO> pageQuery(AgentPageParam params) {
		Boolean seeAllAgent = adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllAgent");
		if(!seeAllAgent){
			params.setOwnerAeName(RequestTool.getAdmin().getName());
		}

		Pagenation<AgentVO> page = new Pagenation<>();
		PagenationDto<BaiqiAgentDto> result = remoteBaiqiAgentBackendService.find4Page(params);
		page.setTotal(result.getTotal());
		// 校验是否有返回数据
		if (result.getTotal() == 0) {
			page.setList(Lists.newArrayList());
			return page;
		}
		page.setList(BeanUtils.copyList(result.getList(),AgentVO.class));
		return page;
	}

	@Override
	public Boolean save(AgentSaveParam agentSaveParam) {
		BaiqiAgentSaveDto saveDto = new BaiqiAgentSaveDto();
		saveDto.setAgentName(agentSaveParam.getAgentName().trim());
		saveDto.setContactMobile(agentSaveParam.getContactMobile().trim());
		saveDto.setContactName(agentSaveParam.getContactName().trim());
		saveDto.setId(agentSaveParam.getId());
		saveDto.setOperator(RequestTool.getAdmin().getEmail());
		saveDto.setOwnerAe(RequestTool.getAdmin().getName());
		if (StringUtil.isNotEmpty(agentSaveParam.getMerchantIds())){
			saveDto.setMerchantIds(StringUtil.stringToListOrderByIds(agentSaveParam.getMerchantIds()));
		}
		try {
			return remoteBaiqiAgentBackendService.save(saveDto);
		} catch (BizException e) {
			throw new QihoManagerException(e.getMessage());
		}
	}

	@Override
	public List<SimpleMerchantVO> findMerchant() {
		return BeanUtils.copyList(remoteBaiqiAgentBackendService.findAllIdAndNames(),SimpleMerchantVO.class);
	}

	@Override
	public List<SimpleMerchantVO> findMerchantByAgentId(Long agentId) {
		return BeanUtils.copyList(remoteBaiqiAgentBackendService.findMerchantsByAgentId(agentId),SimpleMerchantVO.class);
	}

	@Override
	public List<SpecialSimpleVO> findAll() {
		List<BaiqiAgentDto> list = remoteBaiqiAgentBackendService.findAll();
		if(CollectionUtils.isEmpty(list)){
			return Collections.emptyList();
		}
		List<SpecialSimpleVO> vos = new ArrayList<>();
		for (BaiqiAgentDto dto : list) {
			SpecialSimpleVO vo = new SpecialSimpleVO();
			vo.setId(dto.getId());
			vo.setName(dto.getAgentName());
			vo.setContactName(dto.getContactName());
			vos.add(vo);
		}
		return vos;
	}

    @Override
    public List<AgentSimpleVO> findNoOpenInterface(String agentName) {
        List<BaiqiAgentDto> agentDtos = remoteBaiqiAgentBackendService.findNoOpenInterface(agentName);
        return BeanUtils.copyList(agentDtos, AgentSimpleVO.class);
    }
}
