package com.qiho.manager.biz.service.bizlog.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.bizlog.QihoBizlogDto;
import com.qiho.center.api.enums.bizlog.BizLogStatusEnum;
import com.qiho.center.api.enums.bizlog.BizLogTypeEnum;
import com.qiho.center.api.params.bizlog.QihoBizlogParams;
import com.qiho.center.api.remoteservice.bizlog.RemoteBizlogBackendService;
import com.qiho.manager.biz.service.bizlog.QihoBizlogService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.bizlog.QihoBizlogVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by sunchangji on 2017/11/28.
 */
@Service("qihoBizlogService")
public class QihoBizlogServiceImpl implements QihoBizlogService {

    @Resource
    private RemoteBizlogBackendService remoteBizlogBackendService;

    @Override
    public Pagenation<QihoBizlogVO> findPage(int offset, int pageSize) {
        QihoBizlogParams bizlogParams = new QihoBizlogParams();
        bizlogParams.setOffset(offset);
        bizlogParams.setMax(pageSize);
        bizlogParams.setBizType(BizLogTypeEnum.MERCHANT_ORDER_EXPORT.getCode());
        PagenationDto<QihoBizlogDto> qihoBizlogDtoPages = remoteBizlogBackendService.findPage(bizlogParams);

        Pagenation<QihoBizlogVO> pagenation = new Pagenation<>();
        qihoBizlogDtoPages.getList();
        List<QihoBizlogDto> qihoBizlogDtos = qihoBizlogDtoPages.getList();
        pagenation.setList(getQihoBizlogVOs(qihoBizlogDtos));
        pagenation.setTotal(qihoBizlogDtoPages.getTotal());
        return pagenation;
    }

    private List<QihoBizlogVO> getQihoBizlogVOs(List<QihoBizlogDto> qihoBizlogDtos) {
        if (CollectionUtils.isEmpty(qihoBizlogDtos)) {
            return Collections.emptyList();
        }
        List<QihoBizlogVO> qihoBizlogVOS = new ArrayList<>();
        for (QihoBizlogDto dto : qihoBizlogDtos) {
            QihoBizlogVO bizlogVO = new QihoBizlogVO();
            bizlogVO.setId(dto.getId());
            bizlogVO.setBizStatus(dto.getBizStatus());
            bizlogVO.setBizStatusDesc(BizLogStatusEnum.getByCode(dto.getBizStatus()).getDesc());
            bizlogVO.setDownloadUrl(dto.getBizResult());
            JSONObject json = JSONObject.parseObject(dto.getPreCondition());
            String fileName = json.getString("fileName");
            StringBuilder sb = new StringBuilder();
            sb.append(dto.getOperator()).append("_").append(fileName).append(".csv");
            bizlogVO.setFileName(sb.toString());
            qihoBizlogVOS.add(bizlogVO);
        }

        return qihoBizlogVOS;

    }
}
