package com.qiho.manager.biz.service.component;

import com.qiho.manager.biz.params.component.ComponentPageCopyParam;
import com.qiho.manager.biz.params.component.ComponentPagePreParam;
import com.qiho.manager.biz.params.component.ComponentPageSaveParam;
import com.qiho.manager.biz.vo.component.ComponentPagePreviewVO;
import com.qiho.manager.biz.vo.page.PageComponentEditVO;

/**
 * 组件页面服务
 *
 * @author chensong
 * @create 2018-07-27
 */
public interface ComponentPageService {

    /**
     * 预览页面
     *
     * @param param
     * @return
     */
    ComponentPagePreviewVO preview(ComponentPagePreParam param);

    /**
     * 保存页面
     * @param page
     * @return
     */
    Boolean save(ComponentPageSaveParam page);


    /**
     * 编辑页面  反填数据
     * @param pageId
     * @return
     */
    PageComponentEditVO edit(Long pageId);

    /**
     * 复制组件化页面
     * @param param
     * @return
     */
    Boolean copy(ComponentPageCopyParam param);



}
