package com.qiho.manager.biz.service.finance;


import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;
import com.qiho.manager.biz.params.finance.FinanceRechargeParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.finance.FinanceRechargeInfoVO;

/**
 * 账户充值service
 * Author: zhanghuifeng
 * Date:   13:59 2017/12/22
 */
public interface BaiqiFinanceRechargeService {

    /**
     * 分页查询充值订单列表信息
     *
     * @param queryParams 查询参数
     * @return 数据
     */
    Pagenation<FinanceRechargeInfoVO> findPage(BaiqiFinanceRechargeQryParam queryParams);

    /**
     * 提交充值申请
     * @param rechargeParam 参数
     * @return boolean
     */
    Boolean submit(FinanceRechargeParam rechargeParam);

    /**
     * 充值
     * @param rechargeNo 充值单号
     * @param state      需要变更的状态
     * @return 结果
     */
    BaseResultDto audit(Long rechargeNo, Integer state);

    /**
     * 根据充值单号获取充值信息
     * @param rechargeNo 单号
     * @return 信息
     */
    BaiqiFinanceRechargeDetailDto find(Long rechargeNo);
}
