package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.center.api.remoteservice.blackList.RemoteBaiqiBlackListService;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.runnable.BlackListExportRunnable;
import com.qiho.manager.biz.runnable.ordertaskhandler.BlackListHandler;
import com.qiho.manager.biz.runnable.ordertaskhandler.ExpressBlackListHandler;
import com.qiho.manager.biz.service.BlackListService;
import com.qiho.manager.biz.service.OrderDealWithService;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.blackList.BlackListVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

@Service
public class BlackListServiceImpl implements BlackListService, ApplicationContextAware {


    @Resource
    private ExecutorService        executorService;

    @Autowired
    private ApplicationContext     applicationContext;

    @Autowired
    private OrderDealWithService   orderDealWithService;

    @Resource
    private RemoteBaiqiBlackListService remoteBaiqiBlackListService;

    @Override
    public Pagenation<BlackListVO> queryBlackListPage(BaiqiBlackListQueryParam params) {
        Pagenation<BlackListVO> page = new Pagenation<>();
        PagenationDto<BaiqiBlackListDto> pageDto = remoteBaiqiBlackListService.queryBlackListPage(params);
        page.setTotal(pageDto.getTotal());
        if (pageDto.getTotal().intValue() == 0){
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(convertToVoList(pageDto.getList()));
        return page;
    }

    /**
     * 类型转换
     * @param dtoList
     * @return
     */
    private List<BlackListVO> convertToVoList(List<BaiqiBlackListDto> dtoList){
        List<BlackListVO> blackListVOList = dtoList.stream().map(e->{
            BlackListVO vo = BeanUtils.copy(e, BlackListVO.class);
            vo.setDealType(e.getDealType().getDesc());
            vo.setSourceType(e.getSourceType().getDesc());
            vo.setGmtCreate(DateUtils.getSecondStr(e.getGmtCreate()));
            vo.setRemarks(e.getRemark());
            return vo;
        }).collect(Collectors.toList());
        return blackListVOList;
    }

    @Override
    public OrderDealWithVO batchAddBlackList(BatchAuditOrderParam param, JSONObject extraParams) {
        // 批量黑名单添加
        return orderDealWithService.submitDealWithTask(param.getFileUrl(),  BlackListHandler.class, extraParams);
    }


    @Override
    public Boolean deleteBlackList(Long id) {
        String name = RequestTool.getAdmin().getName();
        ResultDto<Boolean> result = remoteBaiqiBlackListService.deleteBlackList(name, id);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Map<String, Object> submitBlackListExport(BaiqiBlackListQueryParam params) {
        BlackListExportRunnable runnable = applicationContext.getBean(BlackListExportRunnable.class);
        runnable.setParams(params);
        Map<String, Object> info = runnable.init();
        executorService.submit(runnable);
        return info;

    }

    @Override
    public OrderDealWithVO batchExpressBlackList(BatchAuditOrderParam param) {
        return orderDealWithService.submitDealWithTask(param.getFileUrl(),  ExpressBlackListHandler.class);
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext){
        this.applicationContext = applicationContext;
    }
}
