package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaWhiteListDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MediaWhiteListQueryParam;
import com.qiho.center.api.remoteservice.campaign.RemoteMediaWhiteListService;
import com.qiho.manager.biz.service.MediaWhiteListService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.WhiteListVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/9/8.
 */
@Service
public class MediaWhiteListServiceImpl implements MediaWhiteListService {

	@Resource
	private RemoteMediaWhiteListService remoteMediaWhiteListService;

	@Override
	public Long saveOrUpdateWhiteList(MediaWhiteListDto mediaWhiteListDto) {
		DubboResult<Long> result = remoteMediaWhiteListService.saveOrUpdateWhiteList(mediaWhiteListDto);
		if(!result.isSuccess()){
			throw new QihoException(result.getMsg());
		}
		return result.getResult();
	}

	@Override
	public Integer deleteWhiteList(Long id) {
		DubboResult<Integer> result = remoteMediaWhiteListService.deleteWhiteListById(id);
		if(result.isSuccess()){
			return result.getResult();
		}else{
			throw new QihoException(result.getMsg());
		}
	}


	@Override
	public Pagenation<WhiteListVO> queryWhiteListByPage(MediaWhiteListQueryParam param) {
		DubboResult<PagenationDto<MediaWhiteListDto>> result = remoteMediaWhiteListService.queryWhiteListPage(param);
		if(!result.isSuccess()){
			throw new QihoException(result.getMsg());
		}
		Pagenation<WhiteListVO> page = new Pagenation<>();
		PagenationDto<MediaWhiteListDto> pagenationDto = result.getResult();
		page.setTotal(pagenationDto.getTotal());
		page.setList(BeanUtils.copyList(pagenationDto.getList(),WhiteListVO.class));
		return page;
	}

	@Override
	public WhiteListVO selectWhiteListById(Long id) {
		DubboResult<MediaWhiteListDto> result = remoteMediaWhiteListService.selectWhiteListById(id);
		if(!result.isSuccess()){
			throw  new QihoException(result.getMsg());
		}
		return BeanUtils.copy(result.getResult(),WhiteListVO.class);
	}
}
