package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.manager.biz.service.SkinService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.SkinVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.ReadResourceUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Date:     2017/7/5 15:06 <br/>
 *
 * @author huika
 * @see
 */
@Service
public class SkinServiceImpl implements SkinService {

    @Autowired
    private RemoteSkinService remoteSkinService;

    @Autowired
    private RemoteAdminService remoteAdminService;

    private static final Logger logger = LoggerFactory.getLogger(SkinServiceImpl.class);

    @Override
    public Long createSkin(SkinDto skinDto) {
        DubboResult<Long> result = remoteSkinService.createSkin(skinDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return result.getResult();
    }

    @Override
    public Boolean updateSkin(SkinDto skinDto) {
        DubboResult<Boolean> result = remoteSkinService.updateSkin(skinDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return result.getResult();
    }

    @Override
    public Boolean deleteSkin(Long id, Long gmtModifier) {
        DubboResult<Boolean> result = remoteSkinService.deleteSkin(id, gmtModifier);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return result.getResult();
    }

    @Override
    public SkinVO querySkinById(Long id) {
        DubboResult<SkinDto> result = remoteSkinService.querySkinById(id);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        SkinVO skinVO = convertVOSimple(result.getResult());
        if (skinVO != null) {
            AdminDto adminDto = null;
            try {
                adminDto = remoteAdminService.findOneAdmin(result.getResult().getGmtModifier());
                skinVO.setGmtModifier(adminDto.getName());
                skinVO.setEmail(adminDto.getEmail());
            } catch (Exception e) {
                logger.warn("获取admin异常，data = {}，", result.getResult().getGmtModifier(), e);
                skinVO.setGmtModifier("");
                skinVO.setEmail("");
            }
        }
        return skinVO;
    }

    @Override
    public Pagenation<SkinVO> queryAllSkin(QuerySkinParams params) {
        DubboResult<PagenationDto<SkinDto>> result = remoteSkinService.queryAllSkin(params);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        PagenationDto<SkinDto> pagenationDto = result.getResult();
        List<SkinVO> skinVOList = Lists.transform(pagenationDto.getList(), this::convertVO);
        Pagenation<SkinVO> pagenation = new Pagenation<>();
        pagenation.setList(skinVOList);
        pagenation.setTotal(pagenationDto.getTotal());
        return pagenation;
    }

    @Override
    public Pagenation<SkinVO> queryBySkinId(Long id) {
        // 根据skinId查询skinDto对象结果集
        DubboResult<SkinDto> result = remoteSkinService.querySkinById(id);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }

        if (null == result.getResult()) {
            return null;
        }

        // 将skinDto转成skinVO并存储在list集合中
        List<SkinVO> skinVOList = new ArrayList<>();
        skinVOList.add(convertVO(result.getResult()));

        // 分页封装
        Pagenation<SkinVO> pagenation = new Pagenation<>();
        pagenation.setList(skinVOList);
        pagenation.setTotal(1);

        return pagenation;
    }

    /**
     * 单个skinVo转换
     * @param dto
     * @return
     */
    private SkinVO convertVOSimple(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        SkinVO vo = new SkinVO();
        BeanUtils.copyProperties(dto, vo);
        vo.setSkinId(dto.getId());
        vo.setGmtModified(DateUtils.getSecondStr(dto.getGmtModified()));
        vo.setCssStr(ReadResourceUtil.readResource(dto.getCssUrl()));
        vo.setHtmlStr(ReadResourceUtil.readResource(dto.getHtmlUrl()));
        vo.setJavascriptStr(ReadResourceUtil.readResource(dto.getJavascriptUrl()));
        return vo;
    }

    private SkinVO convertVO(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        SkinVO vo = new SkinVO();
        BeanUtils.copyProperties(dto, vo);
        vo.setSkinId(dto.getId());
        vo.setGmtModified(DateUtils.getSecondStr(dto.getGmtModified()));
        return vo;
    }
}
