package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.warning.StockWarningDto;
import com.qiho.center.api.params.warning.StockWarningParams;
import com.qiho.center.api.remoteservice.warning.RemoteStockWarningService;
import com.qiho.manager.biz.service.warning.StockWarningService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.warning.WarningVo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2018/1/15.
 */
@Service
public class StockWarningServiceImpl implements StockWarningService {

    @Resource
    RemoteStockWarningService remoteStockWarningService;

    @Override
    public Pagenation<WarningVo> queryListByParam(StockWarningParams params) {
        PagenationDto<StockWarningDto> pg =  remoteStockWarningService.queryByParam(params);
        Pagenation<WarningVo> pagenationDto = new Pagenation<>();
        pagenationDto.setTotal(pg.getTotal());
        List<WarningVo> list = Lists.newArrayList();
        for (StockWarningDto stockWarningDto : pg.getList()) {
            WarningVo vo = BeanUtils.copy(stockWarningDto,WarningVo.class);
            if(stockWarningDto.getWarnStatus()==0){
                vo.setWarnStatus("预警");
            }else{
                vo.setWarnStatus("缺货");
            }
            vo.setSuggestStock(Long.valueOf(stockWarningDto.getSuggestNum()));
            vo.setStock(Long.valueOf(stockWarningDto.getStockNum()));
            vo.setGmtCreate(DateUtils.getSecondStr(stockWarningDto.getGmtCreate()));
            list.add(vo);
        }
        pagenationDto.setList(list);
        return pagenationDto;
    }


}
