package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.enums.PlanStatusEnum;
import com.qiho.center.api.params.TestPlanQueryParam;
import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.api.remoteservice.abtest.RemoteTestMetadataService;
import com.qiho.center.api.remoteservice.abtest.RemoteTestPlanService;
import com.qiho.manager.biz.service.TestPlanService;
import com.qiho.manager.biz.vo.ItemVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.abtest.ItemTestMetadataVO;
import com.qiho.manager.biz.vo.abtest.TestMetadataVO;
import com.qiho.manager.biz.vo.abtest.TestPlanDetailVO;
import com.qiho.manager.biz.vo.abtest.TestPlanVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by qianjue on 2017/10/11.
 */
@Service
public class TestPlanServiceImpl implements TestPlanService {

	private Logger logger = LoggerFactory.getLogger(TestPlanServiceImpl.class);

	@Resource
	RemoteTestPlanService   remoteTestPlanService;

	@Resource
	RemoteItemService   remoteItemService;

	@Resource
	RemoteTestMetadataService  remoteTestMetadataService;

	@Override
	public Pagenation<TestPlanVO> queryPageList(TestPlanQueryParam param) {
		Pagenation<TestPlanVO> page = new Pagenation<>();
		PagenationDto<TestPlanDto> result = remoteTestPlanService.queryTestPlanListByPage(param);
		page.setTotal(result.getTotal());
		List<TestPlanVO> list = Lists.newArrayList();
		result.getList().stream().forEach(dto ->{
			TestPlanVO testPlanVO = new TestPlanVO();
			testPlanVO.setId(dto.getId());
			testPlanVO.setItemId(dto.getItemId());
			testPlanVO.setPlanName(dto.getPlanName());
			testPlanVO.setPlanDesc(dto.getPlanDesc());
			testPlanVO.setStartTime(DateUtils.getSecondStr(dto.getStartTime()));
			testPlanVO.setEndTime(DateUtils.getSecondStr(dto.getEndTime()));
			testPlanVO.setItemName(dto.getItemName());
			testPlanVO.setCreator(dto.getCreator());
			testPlanVO.setUpdator(dto.getUpdator());
			testPlanVO.setGmtCreate(DateUtils.getSecondStr(dto.getGmtCreate()));
			testPlanVO.setGmtModified(DateUtils.getSecondStr(dto.getGmtModified()));
			testPlanVO.setPlanType(MetadataTypeEnum.getByCode(dto.getPlanType()).getDesc());
			// 状态值修改变更
			if(StringUtils.equals(PlanStatusEnum.TO_PUBLISH.getCode(),dto.getPlanStatus())){
				testPlanVO.setPlanStatus("未发布");
			}else if(StringUtils.equals(PlanStatusEnum.PAUSE.getCode(),dto.getPlanStatus())){
				testPlanVO.setPlanStatus("暂停中");
			}else{
				if(dto.getStartTime().after(new Date())){
					testPlanVO.setPlanStatus("未开始");
				}else if(dto.getEndTime().before(new Date())){
					testPlanVO.setPlanStatus("已结束");
				}else{
					testPlanVO.setPlanStatus("进行中");
				}
			}
			list.add(testPlanVO);
		});
		page.setList(list);
		return page;
	}

	@Override
	public ItemTestMetadataVO queryTestMetadataByItemId(Long itemId) {
		ItemTestMetadataVO  vo = new ItemTestMetadataVO();
		//先查询商品信息
		DubboResult<ItemDetailDto> dubboResult = remoteItemService.queryItemDetail(itemId);
		if(null==dubboResult.getResult()){
			throw new QihoManagerException("该商品不存在");
		}
		if(dubboResult.isSuccess()){
			vo.setItemId(itemId);
			vo.setItemName(dubboResult.getResult().getItemName());
			vo.setPicUrl(dubboResult.getResult().getExtParamValue(ItemVO.IMAGESTR));
		}
		//设置其他信息
		vo.setPriceList(transformData(remoteTestMetadataService.selectListByItemIdAndType(itemId, MetadataTypeEnum.PRICE.getCode())));
		vo.setDetailList(transformData(remoteTestMetadataService.selectListByItemIdAndType(itemId,MetadataTypeEnum.DETAIL.getCode())));
		// 新旧皮肤区分
		List<TestMetadataDto> allSkinList = remoteTestMetadataService.selectListByItemIdAndType(itemId,MetadataTypeEnum.SKIN.getCode());
		List<TestMetadataDto> skinList = Lists.newArrayList();
		List<TestMetadataDto> pageList = Lists.newArrayList();
		allSkinList.stream().forEach(skin ->{
			// 判断新旧皮肤  0 旧皮肤 1 新皮肤
			if(skin.getSkinType() == 0){
				skinList.add(skin);
			}else {
				pageList.add(skin);
			}
		});
		vo.setSkinList(transformData(skinList));
		vo.setPageList(transformData(pageList));
		return vo;
	}

	private List<TestMetadataVO> transformData(List<TestMetadataDto> priceList) {
		List<TestMetadataVO> resultlist = Lists.newArrayList();
		if(CollectionUtils.isEmpty(priceList)){
			return resultlist;
		}
		priceList.stream().forEach(dto ->{
			TestMetadataVO vo = new TestMetadataVO();
			vo.setId(dto.getId());
			vo.setItemId(dto.getItemId());
			vo.setMetadataName(dto.getDataName());
			vo.setMetadataDesc(dto.getDataDesc());
			vo.setKeyType(dto.getMetadataKey());
			vo.setSelected(false);
			resultlist.add(vo);
		});
		return resultlist;
	}


	@Override
	public boolean deleteTestPlan(Long planId,String updator) {
		return remoteTestPlanService.deleteTestPlan(planId,updator);
	}

	@Override
	public boolean updateTestPlanStatus(Long planId, String planStatus,String updator) {
		try{
			return remoteTestPlanService.updatePlanStatus(planId,planStatus,updator);
		}catch (BizException exception){
			throw new QihoManagerException(exception.getMessage());
		}

	}

	@Override
	public void saveTestPlan(TestPlanDto testPlanDto) {
		try {
			remoteTestPlanService.saveTestPlan(testPlanDto);
		} catch (BizException e) {
			throw new QihoManagerException(e.getMessage());
		}
	}

	@Override
	public TestPlanVO queryTestEditInfo(Long planId) {
		TestPlanDto testPlanDto = remoteTestPlanService.queryTestPlanById(planId);
		if(null==testPlanDto){
			return null;
		}
		TestPlanVO testPlanVO = BeanUtils.copy(testPlanDto,TestPlanVO.class);
		testPlanVO.setStartTime(DateUtils.getSecondStr(testPlanDto.getStartTime()));
		testPlanVO.setEndTime(DateUtils.getSecondStr(testPlanDto.getEndTime()));
		if(StringUtils.equals(testPlanDto.getPlanStatus(),PlanStatusEnum.NORMAL.getCode())
				&& testPlanDto.getEndTime().before(new Date())){
			testPlanVO.setEdit(false);
		}else{
			testPlanVO.setEdit(true);
		}
		List<TestPlanDetailVO> list = Lists.newArrayList();
		testPlanDto.getDetailDtoList().stream().forEach(detailDto->{
			TestPlanDetailVO detailVO = new TestPlanDetailVO();
			detailVO.setFlowPercent(detailDto.getFlowPercent());
			detailVO.setMetadataPriceId(detailDto.getParam().get(MetadataTypeEnum.PRICE.getCode()));
			detailVO.setMetadataSkinId(detailDto.getParam().get(MetadataTypeEnum.SKIN.getCode()));
			detailVO.setMetatataDetailId(detailDto.getParam().get(MetadataTypeEnum.DETAIL.getCode()));
			list.add(detailVO);
		});
		testPlanVO.setDetailVOList(list);
		return testPlanVO;
	}

	@Override
	public void publisTestPlan(Long planId) {
		try{
			remoteTestPlanService.publishTestPlan(planId);
		}catch(BizException e){
			logger.error("TestPlanServiceImpl call publisTestPlan error,planId = {}",planId,e);
			throw new QihoManagerException(e.getMessage());
		}
	}
}
