package com.qiho.manager.biz.service.menu;

import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.manager.biz.vo.MenuVO;

/**
 * 菜单接口
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-14 14:25
 */
public interface MenuService {

    /**
     * 初始化菜单
     *
     * @return
     */
    Boolean init();

    /**
     * 添加菜单
     *
     * @param menuParams
     * @return
     */
    Boolean save(MenuParams menuParams);

    /**
     * 根据Code查询菜单
     *
     * @param code
     * @return
     */
    MenuVO findByCode(String code);
}
