package com.qiho.manager.biz.service.menu.impl;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.api.remoteservice.menu.RemoteMenuBackendService;
import com.qiho.manager.biz.service.menu.MenuService;
import com.qiho.manager.biz.vo.MenuVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 菜单接口实现
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-14 14:26
 */
@Service("menuServiceImpl")
public class MenuServiceImpl implements MenuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MenuServiceImpl.class);

    @Resource
    private RemoteMenuBackendService remoteMenuBackendService;

    @Override
    public Boolean init() {
        return remoteMenuBackendService.initMenu();
    }

    @Override
    public Boolean save(MenuParams menuParams) {
        try {
            MenuDto menuDto = this.menuParamsToDto(menuParams);

            if (null == menuDto) {
                return Boolean.FALSE;
            }

            if (0 == remoteMenuBackendService.saveMenu(menuDto)) {
                return Boolean.FALSE;
            }

            return Boolean.TRUE;
        } catch (Exception e) {
            LOGGER.error("菜单保存错误", e);
            return Boolean.FALSE;
        }
    }

    @Override
    public MenuVO findByCode(String code) {
        MenuVO menuVO = new MenuVO();
        try {
            MenuParams menuParams = new MenuParams();
            menuParams.setMenuCode(code);

            List<MenuDto> menuDtoList = remoteMenuBackendService.findByParam(menuParams);

            if (null == menuDtoList) {
                return menuVO;
            }

            return menuDtoToVO(menuDtoList.get(0));

        } catch (BizException e) {
            LOGGER.error("根据菜单Code查询", e);
            return menuVO;
        }
    }

    private MenuDto menuParamsToDto(MenuParams menuParams) {
        if (null == menuParams) {
            return null;
        }
        MenuDto menuDto = new MenuDto();
        menuDto.setParentId(menuParams.getParentId());
        menuDto.setMenuCode(menuParams.getMenuCode());
        menuDto.setMenuName(menuParams.getMenuName());
        menuDto.setRemark(menuParams.getRemark());
        menuDto.setSorted(menuParams.getSorted());
        return menuDto;
    }

    private MenuVO menuDtoToVO(MenuDto menuDto) {
        if (menuDto == null) {
            return null;
        }
        MenuVO menuVO = new MenuVO();
        menuVO.setId(menuDto.getId());
        menuVO.setParentId(menuDto.getParentId());
        menuVO.setMenuCode(menuDto.getMenuCode());
        menuVO.setMenuName(menuDto.getMenuName());
        menuVO.setRemark(menuDto.getRemark());
        menuVO.setSorted(menuDto.getSorted());
        menuVO.setDeleted(menuDto.getDeleted());
        menuVO.setGmtCreate(menuDto.getGmtCreate());
        menuVO.setGmtModified(menuDto.getGmtModified());
        return menuVO;
    }

}
