package com.qiho.manager.biz.service.merchant.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantAdvertBackendService;
import com.qiho.manager.biz.params.merchant.MerchantAdvertSaveParam;
import com.qiho.manager.biz.service.merchant.MerchantAdvertService;
import com.qiho.manager.biz.vo.SelectVO;
import com.qiho.manager.biz.vo.merchant.MerchantAdvertVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 商家广告service
 *
 * @author peanut.huang
 * @date 2018/1/2.
 */
@Service("merchantAdvertService")
public class MerchantAdvertServiceImpl implements MerchantAdvertService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantAdvertServiceImpl.class);


    @Resource
    private RemoteMerchantAdvertBackendService remoteMerchantAdvertBackendService;


    @Override
    public List<MerchantAdvertVO> listAllAdvert(Long merchantId) {

        List<MerchantAdvertDto> remoteResult;
        try {
            remoteResult  = remoteMerchantAdvertBackendService.findAll(merchantId);
        }catch (Exception e){
            LOGGER.error("list all advert error:", e);
            return Collections.emptyList();
        }

        return  BeanUtils.copyList(remoteResult, MerchantAdvertVO.class);
    }

    @Override
    public List<MerchantAdvertVO> listAdvertConsume(Long merchantId, Date dateStart, Date dateEnd) {


        List<MerchantAdvertDto> remoteResult;
        try {
            remoteResult  = remoteMerchantAdvertBackendService.findAdvertConsume(merchantId, dateStart, dateEnd);
        }catch (Exception e){
            LOGGER.error("list advert consume error:", e);
            return Collections.emptyList();
        }
        if(CollectionUtils.isEmpty(remoteResult)){
            return Collections.emptyList();
        }

        List<MerchantAdvertVO> result = Lists.newArrayListWithExpectedSize(remoteResult.size());

        remoteResult.forEach(e -> {
            MerchantAdvertVO vo = BeanUtils.copy(e, MerchantAdvertVO.class);

            //金额转换
            Long advertConsume = e.getAdvertConsume();
            if (advertConsume != null) {
                vo.setAdvertConsume(new BigDecimal(advertConsume).movePointLeft(2).toString());
            }

            result.add(vo);

        });

        return result;
    }

    @Override
    public List<SelectVO> listUnlinkedAdvert() {

        List<SimpleIdAndNameDto> remoteResult;
        try {
            remoteResult  = remoteMerchantAdvertBackendService.findUnLinkedAdvert();
        }catch (Exception e){
            LOGGER.error("list unlinked advert error:", e);
            return Collections.emptyList();
        }

        return  BeanUtils.copyList(remoteResult, SelectVO.class);
    }

    @Override
    public Boolean saveLink(MerchantAdvertSaveParam saveParam) {

        MerchantAdvertDto saveDto = BeanUtils.copy(saveParam, MerchantAdvertDto.class);
        try {
            return  remoteMerchantAdvertBackendService.insertMerchantAdvert(saveDto);
        }catch (BizException e){
            throw new QihoManagerException(e.getMessage());
        }catch (Exception e){
            LOGGER.error("save link advert error:", e);
            throw new QihoManagerException("关联失败");
        }
    }
}
