package com.qiho.manager.biz.service.message.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageNotifyPagingParams;
import com.qiho.center.api.remoteservice.message.RemoteMessageBackendService;
import com.qiho.manager.biz.service.message.MessageNotifyService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.message.MessageNotifyVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: wangjin
 * @create 2018-07-03 15:47
 **/
@Service
public class MessageNotifyServiceImpl implements MessageNotifyService {

    @Value("${message.edit.authority}")
    private String accounts;

    private final static String SPLITTER = ",";

    @Autowired
    private RemoteMessageBackendService remoteMessageService;

    @Override
    public Pagenation<MessageNotifyVO> queryMessageList(MessageNotifyPagingParams pagingParams) {
        Pagenation<MessageNotifyVO> pagenation = new Pagenation<>();
        PagenationDto<MessageNotifyDto> pagenationDto = remoteMessageService.findMessages(pagingParams);

        int total = pagenationDto.getTotal();
        List<MessageNotifyDto> list = pagenationDto.getList();

        if(CollectionUtils.isEmpty(list) || total <= 0){
            return pagenation;
        }

        pagenation.setList(ListTrans(list));
        pagenation.setTotal(total);
        return pagenation;
    }

    @Override
    public Boolean checkedUserAuthority() {
        String userAccount = RequestTool.getAdmin().getEmail();
        List<String> accountList = stringTOList();

        return accountList.contains(userAccount);
    }

    /**
     * 转换
     */
    private List<String> stringTOList(){
        String[] accountList = accounts.split(SPLITTER);
        int len = accountList.length;
        List<String> list = new ArrayList<>(len);
        for (String a : accountList){
            //去重
            if(!list.contains(a)){
                list.add(a);
            }
        }
        return list;
    }

    /**
     * 日期转换
     * @param list
     * @return
     */
    private List<MessageNotifyVO> ListTrans(List<MessageNotifyDto> list){

        List<MessageNotifyVO> pagenation = new ArrayList<>();

        list.stream().forEach(item ->{
            MessageNotifyVO vo = BeanUtils.copy(item,MessageNotifyVO.class);
            vo.setGmtCreate(DateUtils.getSecondStr(item.getGmtCreate()));
            pagenation.add(vo);
        });

        return pagenation;

    }
}
