package com.qiho.manager.biz.service.page;

import com.qiho.manager.biz.vo.page.CollItemVO;
import com.qiho.manager.common.param.SaveCollItemStyleParam;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-24.
 */
public interface CollItemService {

    /**
     * 查询集合页商品列表
     *
     * @param collId 集合页id
     * @return List<CollItemVO>
     */
    List<CollItemVO> queryItemListBySort(Long collId);

    /**
     * 新增集合页商品
     *
     * @param collId
     * @param itemIdList
     * @return Integer
     */
    Integer addCollItemList(Long collId, List<Long> itemIdList);

    /**
     * 物理删除集合页商品
     *
     * @param collId
     * @param itemId
     * @return Integer
     */
    Integer deleted4Phy(Long collId, Long itemId);

    /**
     * 排序集合页商品
     *
     * @param collId
     * @param itemIds
     * @return Integer
     */
    Integer sort(Long collId, List<Long> itemIds);

    /**
     * 批量更新集合页商品状态
     *
     * @param collId
     * @param itemIdList
     * @param collItemStatus
     * @return Integer
     */
    Integer updateStatusBatch(Long collId, List<Long> itemIdList, Integer collItemStatus);

    /**
     * 判断商品列表中是否有库存为0的商品
     *
     * @param itemIdList
     * @return Integer
     */
    Boolean checkStock(List<Long> itemIdList);

    /**
     * 保存集合页样式信息
     *
     * @param param
     * @return Integer
     */
    Integer saveStyle(SaveCollItemStyleParam param);

    /**
     * 批量删除所有集合页中的商品
     *
     * @param itemIds
     * @return Integer
     */
    Integer batchDeleted(List<Long> itemIds);
}
