package com.qiho.manager.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.remoteservice.page.RemoteCollPageBackendService;
import com.qiho.manager.biz.service.page.CollPageService;
import com.qiho.manager.biz.vo.page.CollPageVO;
import com.qiho.manager.biz.vo.page.CollSkinVO;
import com.qiho.manager.common.constant.DomainConstantUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
@Service("collPageService")
public class CollPageServiceImpl implements CollPageService {

    @Resource
    private RemoteCollPageBackendService remoteCollPageBackendService;

    @Override
    public List<CollPageVO> queryList() {
        List<CollPageDto> collPageDtoList = remoteCollPageBackendService.queryList();

        if (CollectionUtils.isEmpty(collPageDtoList)) {
            return Lists.newArrayList();
        }

        // 最多展示50条
        int maxLen = 50;
        if (collPageDtoList.size() > maxLen) {
            collPageDtoList = collPageDtoList.subList(0, maxLen);
        }

        return transformCollPageVO(collPageDtoList);
    }

    @Override
    public List<CollPageVO> transformCollPageVO(List<CollPageDto> collPageDtoList) {
        // 类型转换
        return Lists.transform(collPageDtoList, collPageDto -> {
            CollPageVO collPageVO = BeanUtils.copy(collPageDto, CollPageVO.class);

            // 设置集合页URL
            collPageVO.setCollPageURL(DomainConstantUtil.getQihoWebUrl() + "/collection/index?collId="
                    + collPageDto.getId() + "&pid=" + collPageDto.getPageSkinId());

            return collPageVO;
        });
    }

    @Override
    public List<CollSkinVO> querySkinList() {

        // 查询集合页新皮肤
        List<BaiqiPageDto> collectionSkinList = remoteCollPageBackendService.querySkinList(PageTypeEnum.ITEM_COLLECTION.getValue());

        // 查询组件化集合页皮肤
        List<BaiqiPageDto> componentCollectionSkinList = remoteCollPageBackendService.querySkinList(PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue());

        // 非null处理
        if (CollectionUtils.isEmpty(collectionSkinList)) {
            collectionSkinList = Lists.newArrayList();
        }

        // 集合页新皮肤 + 组件化集合页皮肤
        if (CollectionUtils.isNotEmpty(componentCollectionSkinList)) {
            collectionSkinList.addAll(componentCollectionSkinList);
        }

        if (CollectionUtils.isEmpty(collectionSkinList)) {
            return Lists.newArrayList();
        }

        List<CollSkinVO> collSkinVOList = Lists.newArrayList();
        // 提取页面模板的id和名称
        collectionSkinList.forEach(baiqiPageDto -> {
                    CollSkinVO collSkinVO = new CollSkinVO();
                    collSkinVO.setId(baiqiPageDto.getId());
                    collSkinVO.setLabel(baiqiPageDto.getPageName());
                    collSkinVOList.add(collSkinVO);
                }
        );

        // 反转顺序, 但保留第一个皮肤的位置
        CollSkinVO firstCollSkinVO = collSkinVOList.get(0);
        List<CollSkinVO> reverseList = Lists.reverse(collSkinVOList);
        reverseList.remove(reverseList.size() - 1);
        reverseList.add(0, firstCollSkinVO);

        return reverseList;
    }

    @Override
    public Integer saveCollPage(CollPageDto collPageDto) {
        Integer result;
        if (null == collPageDto.getId() || collPageDto.getId().longValue() <= 0) {
            result = remoteCollPageBackendService.addCollPage(collPageDto);
        } else {
            result = remoteCollPageBackendService.updateCollPage(collPageDto);
        }
        return result;
    }
}
