package com.qiho.manager.biz.service.region.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.region.BaiqiRegionDto;
import com.qiho.center.api.remoteservice.region.RemoteBaiqiRegionService;
import com.qiho.manager.biz.service.region.BaiqiRegionService;
import com.qiho.manager.biz.vo.region.RegionVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 中国省市区乡镇服务
 * Author：zhanghuifeng
 * Date: Created in 16:02 2018/2/26
 */
@Service("baiqiRegionService")
public class BaiqiRegionServiceImpl implements BaiqiRegionService {

    @Resource
    private RemoteBaiqiRegionService remoteBaiqiRegionService;

    @Override
    public List<BaiqiRegionDto> find(Long parentId) {
        return remoteBaiqiRegionService.find(parentId);
    }

    @Override
    public Boolean fixAreaNum(Integer batchNum) {
        int startId = batchNum*1000;
        int endId = (batchNum + 1)*1000;
        return remoteBaiqiRegionService.updateAreaNum(startId,endId);
    }

    @Override
    public List<RegionVO> findNullAreaNumRegion(Integer regionLevel) {
        return BeanUtils.copyList(remoteBaiqiRegionService.findNullAreaNumRegion(regionLevel),RegionVO.class);
    }

    @Override
    public Boolean updateAreaNumByRegionName(String regionName, int areaNum) {
        return remoteBaiqiRegionService.updateAreaNumByRegionName(regionName, areaNum);
    }

    @Override
    public RegionVO findByNameAndLevel(String regionName, int regionLevel) {
        return BeanUtils.copy(remoteBaiqiRegionService.findByNameAndLevel(regionName, regionLevel), RegionVO.class);
    }
}
