package com.qiho.manager.biz.service.template.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.template.AppWhiteDto;
import com.qiho.center.api.params.template.AppWhitePagingParam;
import com.qiho.center.api.params.template.AppWhiteParam;
import com.qiho.center.api.remoteservice.template.RemoteAppWhiteService;
import com.qiho.manager.biz.service.template.AppWhiteService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.template.TemplateAppWhiteVo;
import com.qiho.manager.common.enums.MessageManagementEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Wangpf
 * @description 媒体白名单service
 * @date 2020/2/11 9:19 PM
 */
@Service
public class AppWhiteServiceImpl implements AppWhiteService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppWhiteServiceImpl.class);

    @Autowired
    private RemoteAppWhiteService remoteAppWhiteService;

    /**
     * 全部场景
     */
    private static final String ALL_SCENE = "ALL";

    @Override
    public boolean save(AppWhiteParam appWhiteParam) {
        //设置创建者名称
        AdminDto admin = RequestTool.getAdmin();
        appWhiteParam.setCreator(admin == null ? StringUtils.EMPTY : admin.getName());

        DubboResult dubboResult = remoteAppWhiteService.save(appWhiteParam);
        if (!dubboResult.isSuccess()) {
            throw new QihoManagerException(dubboResult.getMsg());
        }
        return dubboResult.isSuccess();
    }

    @Override
    public Pagenation<TemplateAppWhiteVo> pageQuery(AppWhitePagingParam appWhitePagingParam) {
        Pagenation<TemplateAppWhiteVo> pagenation = new Pagenation();
        if(ALL_SCENE.equals(appWhitePagingParam.getScene())){
            appWhitePagingParam.setScene(StringUtils.EMPTY);
        }

        PagenationDto<AppWhiteDto> dtoPagenationDto = remoteAppWhiteService.pageQuery(appWhitePagingParam);
        List<AppWhiteDto> dtoList = dtoPagenationDto.getList();
        Integer total = dtoPagenationDto.getTotal();
        if (CollectionUtils.isEmpty(dtoList) || total == null || total <= 0) {
            return pagenation;
        }
        buildSceneText(dtoList);
        pagenation.setList(BeanUtils.copyList(dtoList, TemplateAppWhiteVo.class));
        pagenation.setTotal(total);

        return pagenation;
    }

    private void buildSceneText(List<AppWhiteDto> dtoList) {
        dtoList.forEach(appWhiteDto -> {
            String scene = appWhiteDto.getScene();
            String desc = MessageManagementEnum.getDescByCode(scene);
            appWhiteDto.setScene(desc);
        });
    }

    @Override
    public boolean delete(Long id) {
        if (id == null) {
            throw new QihoManagerException("Param id can not be null");
        }
        boolean delete = remoteAppWhiteService.delete(id);
        if(delete){
            //成功删除记录日志
            LOGGER.info("App white was deleted id:{},admin:{}",id,JSON.toJSONString(RequestTool.getAdmin()));
        }
        return delete;
    }

}
