/**
 * Project Name:qiho-manager-biz File Name:ItemVO.java Package Name:com.qiho.manager.biz.vo Date:2017年5月17日下午6:27:42
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ItemVO <br/>
 * 商品基本信息 <br/>
 * Date: 2017年5月17日 下午6:27:42 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel(value = "商品展示对象")
public class ItemVO {

    /** 商品类目ID列表 */
    public static final String CATEGORY_ID_LIST  = "categoryIdList";

    /** 商品一级类目名称 */
    public static final String TOP_CATEGORY_NAME = "topCategoryName";

    /** 商品图片 */
    public static final String IMAGESTR             = "image";

    /** 倒计时循环时间 */
    public static final String COUNT_DOWN_CYCLE  = "countDownCycle";

    /** 倒计时最小时间 */
    public static final String COUNT_DOWN_LIMIT  = "countDownLimit";

    /** 购买数量限制 */
    public static final String LIMIT_NUMBER = "limitNumber";

    /** 图片高度 */
    public static final String IMG_HEIGHT = "imgHeight";

    /** 商品主图地址  */
    public static final String MAIN_IMG_URL = "mainImgUrl";

    /** 商品介绍 */
    public static final String ITEM_INTRODUCE = "itemIntroduce";

    /** 营销标签 */
    public static final String SALE_LABLE_URL = "saleLableUrl";

	/**
     * 支持货到付款
     */
    public static final String SUPPORT_COD = "supportCOD";

    @ApiModelProperty(value = "商品ID", required = true)
    private Long               id;

    @ApiModelProperty(value = "一级类目ID", required = true)
    private Long               topCategoryId;

    @ApiModelProperty(value = "一级类目名称", required = true)
    private String             topCategoryName;

    @ApiModelProperty(value = "商品标题", required = true)
    private String             itemName;

    @ApiModelProperty(value = "商品简称", required = true)
    private String             itemShortName;

    @ApiModelProperty(value = "商品货号")
    private String             itemNo;

    @ApiModelProperty(value = "商品状态，ON-上架/OFF-下架", required = true)
    private String             itemStatus;

    @ApiModelProperty(value = "商品详情页URL", required = true)
    private String             url;

    @ApiModelProperty(value = "最低价格，单位：分", required = true)
    private Integer            minPrice;

    @ApiModelProperty(value = "库存", required = true)
    private Long               stock;

    @ApiModelProperty(value = "商品图片", required = true)
    private String             image;

    @ApiModelProperty(value = "是否已推荐", required = true)
    private Boolean            isRecommend;

    @ApiModelProperty("最低价格的SKU的原价，单位：分")
    private Integer            minSkuOriginalPrice;

    @ApiModelProperty("最低价格的SKU的差价，单位：分")
    private Integer            minSkuPriceDiff;

    @ApiModelProperty("差价最大的SKU的差价，单位：分")
    private Integer            maxPriceDiff;

    @ApiModelProperty("差价最大的SKU的价格，单位：分")
    private Integer            maxPriceDiffPrice;

    @ApiModelProperty("差价最大的SKU的原价，单位：分")
    private Integer            maxPriceDiffOriginalPrice;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * topCategoryId.
     *
     * @return the topCategoryId
     */
    public Long getTopCategoryId() {
        return topCategoryId;
    }

    /**
     * topCategoryId.
     *
     * @param topCategoryId the topCategoryId to set
     */
    public void setTopCategoryId(Long topCategoryId) {
        this.topCategoryId = topCategoryId;
    }

    /**
     * topCategoryName.
     *
     * @return the topCategoryName
     */
    public String getTopCategoryName() {
        return topCategoryName;
    }

    /**
     * topCategoryName.
     *
     * @param topCategoryName the topCategoryName to set
     */
    public void setTopCategoryName(String topCategoryName) {
        this.topCategoryName = topCategoryName;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * itemShortName.
     *
     * @return the itemShortName
     */
    public String getItemShortName() {
        return itemShortName;
    }

    /**
     * itemShortName.
     *
     * @param itemShortName the itemShortName to set
     */
    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    /**
     * itemNo.
     *
     * @return the itemNo
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * itemNo.
     *
     * @param itemNo the itemNo to set
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * itemStatus.
     *
     * @return the itemStatus
     */
    public String getItemStatus() {
        return itemStatus;
    }

    /**
     * itemStatus.
     *
     * @param itemStatus the itemStatus to set
     */
    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    /**
     * url.
     *
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     *
     * @param url the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * minPrice.
     *
     * @return the minPrice
     */
    public Integer getMinPrice() {
        return minPrice;
    }

    /**
     * minPrice.
     *
     * @param minPrice the minPrice to set
     */
    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    /**
     * stock.
     *
     * @return the stock
     */
    public Long getStock() {
        return stock;
    }

    /**
     * stock.
     *
     * @param stock the stock to set
     */
    public void setStock(Long stock) {
        this.stock = stock;
    }

    /**
     * image.
     *
     * @return the image
     */
    public String getImage() {
        return image;
    }

    /**
     * image.
     *
     * @param image the image to set
     */
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * isRecommend.
     *
     * @return the isRecommend
     */
    public Boolean getIsRecommend() {
        return isRecommend;
    }

    /**
     * isRecommend.
     *
     * @param isRecommend the isRecommend to set
     */
    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getMinSkuOriginalPrice() {
        return minSkuOriginalPrice;
    }

    public void setMinSkuOriginalPrice(Integer minSkuOriginalPrice) {
        this.minSkuOriginalPrice = minSkuOriginalPrice;
    }

    public Integer getMinSkuPriceDiff() {
        return minSkuPriceDiff;
    }

    public void setMinSkuPriceDiff(Integer minSkuPriceDiff) {
        this.minSkuPriceDiff = minSkuPriceDiff;
    }

    public Integer getMaxPriceDiff() {
        return maxPriceDiff;
    }

    public void setMaxPriceDiff(Integer maxPriceDiff) {
        this.maxPriceDiff = maxPriceDiff;
    }

    public Integer getMaxPriceDiffPrice() {
        return maxPriceDiffPrice;
    }

    public void setMaxPriceDiffPrice(Integer maxPriceDiffPrice) {
        this.maxPriceDiffPrice = maxPriceDiffPrice;
    }

    public Integer getMaxPriceDiffOriginalPrice() {
        return maxPriceDiffOriginalPrice;
    }

    public void setMaxPriceDiffOriginalPrice(Integer maxPriceDiffOriginalPrice) {
        this.maxPriceDiffOriginalPrice = maxPriceDiffOriginalPrice;
    }
}
