/**
 * Project Name:qiho-web-biz File Name:OrderVO.java Package Name:com.qiho.web.biz.vo Date:2017年6月5日下午4:44:24 Copyright
 * (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:OrderVO <br/>
 * 订单信息. <br/>
 * Date: 2017年6月5日 下午4:44:24 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("订单信息")
public class OrderVO {

    @ApiModelProperty("订单ID")
    private String  orderId;

    @ApiModelProperty("下单时间，格式yyyy-MM-dd HH:MM:SS")
    private String  gmtCreate;

    @ApiModelProperty("更新时间，格式yyyy-MM-dd HH:MM:SS")
    private String  gmtModified;

    @ApiModelProperty("订单金额，单位：分")
    private Integer orderAmt;

    @ApiModelProperty("发货方式")
    private String  delivery;

    @ApiModelProperty("订单状态")
    private String  orderStatus;

    @ApiModelProperty("备注")
    private String  remark;

    @ApiModelProperty("手机号码")
    private String  mobile;

    @ApiModelProperty("客户姓名")
    private String  consumerName;

    @ApiModelProperty("行政区划代码")
    private String  areaNum;

    @ApiModelProperty("省/直辖市")
    private String  province;

    @ApiModelProperty("市")
    private String  city;

    @ApiModelProperty("区县")
    private String  district;

    @ApiModelProperty("详细地址")
    private String  address;

    @ApiModelProperty("留言")
    private String  message;

    @ApiModelProperty("是否可以发起售后")
    private Boolean sponsorAftersale;

    @ApiModelProperty("订单扩展信息")
    private OrderDetailExtVo ext;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public String getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public String getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * orderAmt.
     *
     * @return the orderAmt
     */
    public Integer getOrderAmt() {
        return orderAmt;
    }

    /**
     * orderAmt.
     *
     * @param orderAmt the orderAmt to set
     */
    public void setOrderAmt(Integer orderAmt) {
        this.orderAmt = orderAmt;
    }

    /**
     * delivery.
     *
     * @return the delivery
     */
    public String getDelivery() {
        return delivery;
    }

    /**
     * delivery.
     *
     * @param delivery the delivery to set
     */
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public String getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * remark.
     *
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * mobile.
     *
     * @return the mobile
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * mobile.
     *
     * @param mobile the mobile to set
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * consumerName.
     *
     * @return the consumerName
     */
    public String getConsumerName() {
        return consumerName;
    }

    /**
     * consumerName.
     *
     * @param consumerName the consumerName to set
     */
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    /**
     * areaNum.
     *
     * @return the areaNum
     */
    public String getAreaNum() {
        return areaNum;
    }

    /**
     * areaNum.
     *
     * @param areaNum the areaNum to set
     */
    public void setAreaNum(String areaNum) {
        this.areaNum = areaNum;
    }

    /**
     * province.
     *
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * district.
     *
     * @return the district
     */
    public String getDistrict() {
        return district;
    }

    /**
     * district.
     *
     * @param district the district to set
     */
    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * address.
     *
     * @param address the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * message.
     *
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     *
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean getSponsorAftersale() {
        return sponsorAftersale;
    }

    public void setSponsorAftersale(Boolean sponsorAftersale) {
        this.sponsorAftersale = sponsorAftersale;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public OrderDetailExtVo getExt() {
        return ext;
    }

    public void setExt(OrderDetailExtVo ext) {
        this.ext = ext;
    }
}
