package com.qiho.manager.biz.vo.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by sunchangji on 2017/12/11.
 */
@ApiModel("账号实体")
public class MainAccountVO {
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("账户名称")
    private String account;

    @ApiModelProperty("0-商家,2-代理商")
    private Integer accountType;

    @ApiModelProperty("关联id,(accountType=0则为商家id,accountType=2则为代理商id)")
    private Long relationId;

    @ApiModelProperty("accountType=0则为商家名称,accountType=2则为代理商名称)")
    private String relationName;

    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("密码,返回的密码并非是数据库中的密码")
    private String pwd;

    @ApiModelProperty("账户状态(0:禁用,1:启用)")
    private Integer state;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getRelationName() {
        return relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public String getAccountTypeName() {
        return accountTypeName;
    }

    public void setAccountTypeName(String accountTypeName) {
        this.accountTypeName = accountTypeName;
    }
}
