package com.qiho.manager.biz.vo.homepage;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import net.sf.json.JSONObject;

/**
 * Created by qianjue on 2017/8/29.
 */
@ApiModel(value="首页商品区商品展示对象")
public class TabItemVO {

	@ApiModelProperty(value = "记录主键ID", required = true)
	private  Long   id;

	@ApiModelProperty(value = "栏目ID", required = true)
	private  Long   tabId;

	@ApiModelProperty(value = "商品ID", required = true)
	private  Long   itemId;

	@ApiModelProperty(value = "置顶排序值", required = true)
	private  Long   topPayload;

	@ApiModelProperty(value = "商品货号", required = true)
	private String  itemNo;

	@ApiModelProperty(value = "商品名称", required = true)
	private String  itemName;

	@ApiModelProperty(value = "商品简称", required = true)
	private String   itemShortName;

	@ApiModelProperty(value = "商品状态 ON-上架/OFF-下架", required = true)
	private String  itemStatus;

	@ApiModelProperty(value = "商品最近3天销售数量", required = true)
	private Integer   recentlySaleNum;

	@ApiModelProperty(value = "商品库存", required = true)
	private Long   stock;

	@ApiModelProperty(value = "商品价格,单位:分", required = true)
	private Integer  minPrice;

	@ApiModelProperty(value = "商品图片URL", required = true)
	private String   image;

	@ApiModelProperty(value = "商品是否置顶", required = true)
	private  Boolean  isTop;

	@ApiModelProperty(value = "商品在当前tab下的启用状态 0-禁用/1-启用", required = true)
	private  Integer  tabItemStatus;

	@ApiModelProperty(value = "商品样式信息 styleType(1-皮肤样式/2-页面模板)，styleId(皮肤样式或页面模板对应的id)", required = true)
	private JSONObject styleConfig;

	@ApiModelProperty(value = "商品样式对应的名称", required = true)
	private  String  styleName;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getTabId() {
		return tabId;
	}

	public void setTabId(Long tabId) {
		this.tabId = tabId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getTopPayload() {
		return topPayload;
	}

	public void setTopPayload(Long topPayload) {
		this.topPayload = topPayload;
	}

	public String getItemNo() {
		return itemNo;
	}

	public void setItemNo(String itemNo) {
		this.itemNo = itemNo;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getItemShortName() {
		return itemShortName;
	}

	public void setItemShortName(String itemShortName) {
		this.itemShortName = itemShortName;
	}

	public String getItemStatus() {
		return itemStatus;
	}

	public void setItemStatus(String itemStatus) {
		this.itemStatus = itemStatus;
	}

	public Integer getRecentlySaleNum() {
		return recentlySaleNum;
	}

	public void setRecentlySaleNum(Integer recentlySaleNum) {
		this.recentlySaleNum = recentlySaleNum;
	}

	public Long getStock() {
		return stock;
	}

	public void setStock(Long stock) {
		this.stock = stock;
	}

	public Integer getMinPrice() {
		return minPrice;
	}

	public void setMinPrice(Integer minPrice) {
		this.minPrice = minPrice;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Boolean getTop() {
		return null != topPayload && topPayload >0;
	}

	public Integer getTabItemStatus() {
		return tabItemStatus;
	}

	public void setTabItemStatus(Integer tabItemStatus) {
		this.tabItemStatus = tabItemStatus;
	}

	public JSONObject getStyleConfig() {
		return styleConfig;
	}

	public void setStyleConfig(JSONObject styleConfig) {
		this.styleConfig = styleConfig;
	}

	public String getStyleName() {
		return styleName;
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}
}
