package com.qiho.manager.biz.vo.logistics;

import io.swagger.annotations.ApiModel;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.qiho.center.api.enums.YTOErrorCodeReturnEnum;

/**
 * ClassName: LogisticsOrderVO <br/>
 * Function: 圆通物流状态通知接口返回信息. <br/>
 * date: 2017年6月3日 下午12:42:39 <br/>
 *
 * @author chencheng
 * @version
 */
@ApiModel(value = "圆通物流状态通知接口返回信息")
@XmlRootElement(name = "Response")
@XmlType(propOrder = { "logisticProviderID", "txLogisticID", "success","reason"})
public class YTOLogisticsReturnVO {

    /** 物流公司ID（YTO） */
    private String logisticProviderID;

    /** 物流号 */
    private String txLogisticID;

    /** true/false */
    private Boolean success;

    /** 原因 */
    private String reason;

    /**
     * logisticProviderID.
     *
     * @return the logisticProviderID
     */
    public String getLogisticProviderID() {
        return logisticProviderID;
    }

    /**
     * logisticProviderID.
     *
     * @param logisticProviderID the logisticProviderID to set
     */
    @XmlElement
    public void setLogisticProviderID(String logisticProviderID) {
        this.logisticProviderID = logisticProviderID;
    }

    /**
     * txLogisticID.
     *
     * @return the txLogisticID
     */
    public String getTxLogisticID() {
        return txLogisticID;
    }

    /**
     * txLogisticID.
     *
     * @param txLogisticID the txLogisticID to set
     */
    @XmlElement
    public void setTxLogisticID(String txLogisticID) {
        this.txLogisticID = txLogisticID;
    }

    /**
     * success.
     *
     * @return the success
     */
    public Boolean getSuccess() {
        return success;
    }

    /**
     * success.
     *
     * @param success the success to set
     */
    @XmlElement
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    /**
     * reason.
     *
     * @return the reason
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     */
    @XmlElement
    public void setReason(String reason) {
        this.reason = reason;
    }

    public YTOLogisticsReturnVO() {
        super();
    }

    public YTOLogisticsReturnVO(String expressCompanyCode) {
        this.logisticProviderID = expressCompanyCode;
    }

    public void setSuccessAndReason(YTOErrorCodeReturnEnum logisticsError) {
        this.success = logisticsError.getCode();
        if (logisticsError != YTOErrorCodeReturnEnum.SUCCESS) {
            this.reason = logisticsError.getDesc();
        }
    }

}
