package com.qiho.manager.biz.params.component;

import com.qiho.center.api.dto.page.PageFormStrategyDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author chensong
 * @create 2018-07-30
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel("页面组件保存参数")
@Data
public class ComponentPageSaveParam extends ComponentPagePreParam {

    @ApiModelProperty("预览时生成的Md5摘要")
    @NotBlank(message = "MD5只要不能为空")
    private String md5;

    @ApiModelProperty("页面文件地址")
    @NotBlank(message = "页面文件地址不能为空")
    private String pageFileUrl;

    @ApiModelProperty("页面模板名称")
    @NotBlank(message = "页面模板名称不能为空")
    @Size(max = 20, min = 1, message = "页面模板名称长度在1-20个字符")
    private String pageName;

    @ApiModelProperty("js对接平台")
    private Integer jsPlatform;

    @ApiModelProperty("页面表单策略")
    private List<PageFormStrategyDto> strategyTypeList;
}
